<?php

namespace Geniki\GenikiService;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Helper GenikiService
 * @package Geniki
 * @subpackage Services
 */
class GenikiHelper extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Helper
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Geniki\GenikiStruct\GenikiHelper $parameters
     * @return \Geniki\GenikiStruct\GenikiHelperResponse|bool
     */
    public function Helper(\Geniki\GenikiStruct\GenikiHelper $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Helper($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Geniki\GenikiStruct\GenikiHelperResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
