<?php

namespace Geniki\GenikiStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateJob GenikiStruct
 * @package Geniki
 * @subpackage Structs
 */
class GenikiCreateJob extends AbstractStructBase
{
    /**
     * The eType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $eType;
    /**
     * The sAuthKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sAuthKey;
    /**
     * The oVoucher
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Geniki\GenikiStruct\GenikiRecord
     */
    public $oVoucher;
    /**
     * Constructor method for CreateJob
     * @uses GenikiCreateJob::setEType()
     * @uses GenikiCreateJob::setSAuthKey()
     * @uses GenikiCreateJob::setOVoucher()
     * @param string $eType
     * @param string $sAuthKey
     * @param \Geniki\GenikiStruct\GenikiRecord $oVoucher
     */
    public function __construct($eType = null, $sAuthKey = null, \Geniki\GenikiStruct\GenikiRecord $oVoucher = null)
    {
        $this
            ->setEType($eType)
            ->setSAuthKey($sAuthKey)
            ->setOVoucher($oVoucher);
    }
    /**
     * Get eType value
     * @return string
     */
    public function getEType()
    {
        return $this->eType;
    }
    /**
     * Set eType value
     * @uses \Geniki\GenikiEnum\GenikiJobType::valueIsValid()
     * @uses \Geniki\GenikiEnum\GenikiJobType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $eType
     * @return \Geniki\GenikiStruct\GenikiCreateJob
     */
    public function setEType($eType = null)
    {
        // validation for constraint: enumeration
        if (!\Geniki\GenikiEnum\GenikiJobType::valueIsValid($eType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Geniki\GenikiEnum\GenikiJobType', is_array($eType) ? implode(', ', $eType) : var_export($eType, true), implode(', ', \Geniki\GenikiEnum\GenikiJobType::getValidValues())), __LINE__);
        }
        $this->eType = $eType;
        return $this;
    }
    /**
     * Get sAuthKey value
     * @return string|null
     */
    public function getSAuthKey()
    {
        return $this->sAuthKey;
    }
    /**
     * Set sAuthKey value
     * @param string $sAuthKey
     * @return \Geniki\GenikiStruct\GenikiCreateJob
     */
    public function setSAuthKey($sAuthKey = null)
    {
        // validation for constraint: string
        if (!is_null($sAuthKey) && !is_string($sAuthKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sAuthKey, true), gettype($sAuthKey)), __LINE__);
        }
        $this->sAuthKey = $sAuthKey;
        return $this;
    }
    /**
     * Get oVoucher value
     * @return \Geniki\GenikiStruct\GenikiRecord|null
     */
    public function getOVoucher()
    {
        return $this->oVoucher;
    }
    /**
     * Set oVoucher value
     * @param \Geniki\GenikiStruct\GenikiRecord $oVoucher
     * @return \Geniki\GenikiStruct\GenikiCreateJob
     */
    public function setOVoucher(\Geniki\GenikiStruct\GenikiRecord $oVoucher = null)
    {
        $this->oVoucher = $oVoucher;
        return $this;
    }
}
