<?php

namespace Geniki\GenikiStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Checkpoint GenikiStruct
 * @package Geniki
 * @subpackage Structs
 */
class GenikiCheckpoint extends AbstractStructBase
{
    /**
     * The StatusDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $StatusDate;
    /**
     * The Latitude
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Latitude;
    /**
     * The Longitude
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Longitude;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * The StatusCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StatusCode;
    /**
     * The Shop
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Shop;
    /**
     * Constructor method for Checkpoint
     * @uses GenikiCheckpoint::setStatusDate()
     * @uses GenikiCheckpoint::setLatitude()
     * @uses GenikiCheckpoint::setLongitude()
     * @uses GenikiCheckpoint::setStatus()
     * @uses GenikiCheckpoint::setStatusCode()
     * @uses GenikiCheckpoint::setShop()
     * @param string $statusDate
     * @param float $latitude
     * @param float $longitude
     * @param string $status
     * @param string $statusCode
     * @param string $shop
     */
    public function __construct($statusDate = null, $latitude = null, $longitude = null, $status = null, $statusCode = null, $shop = null)
    {
        $this
            ->setStatusDate($statusDate)
            ->setLatitude($latitude)
            ->setLongitude($longitude)
            ->setStatus($status)
            ->setStatusCode($statusCode)
            ->setShop($shop);
    }
    /**
     * Get StatusDate value
     * @return string
     */
    public function getStatusDate()
    {
        return $this->StatusDate;
    }
    /**
     * Set StatusDate value
     * @param string $statusDate
     * @return \Geniki\GenikiStruct\GenikiCheckpoint
     */
    public function setStatusDate($statusDate = null)
    {
        // validation for constraint: string
        if (!is_null($statusDate) && !is_string($statusDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusDate, true), gettype($statusDate)), __LINE__);
        }
        $this->StatusDate = $statusDate;
        return $this;
    }
    /**
     * Get Latitude value
     * @return float
     */
    public function getLatitude()
    {
        return $this->Latitude;
    }
    /**
     * Set Latitude value
     * @param float $latitude
     * @return \Geniki\GenikiStruct\GenikiCheckpoint
     */
    public function setLatitude($latitude = null)
    {
        // validation for constraint: float
        if (!is_null($latitude) && !(is_float($latitude) || is_numeric($latitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($latitude, true), gettype($latitude)), __LINE__);
        }
        $this->Latitude = $latitude;
        return $this;
    }
    /**
     * Get Longitude value
     * @return float
     */
    public function getLongitude()
    {
        return $this->Longitude;
    }
    /**
     * Set Longitude value
     * @param float $longitude
     * @return \Geniki\GenikiStruct\GenikiCheckpoint
     */
    public function setLongitude($longitude = null)
    {
        // validation for constraint: float
        if (!is_null($longitude) && !(is_float($longitude) || is_numeric($longitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($longitude, true), gettype($longitude)), __LINE__);
        }
        $this->Longitude = $longitude;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \Geniki\GenikiStruct\GenikiCheckpoint
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get StatusCode value
     * @return string|null
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }
    /**
     * Set StatusCode value
     * @param string $statusCode
     * @return \Geniki\GenikiStruct\GenikiCheckpoint
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: string
        if (!is_null($statusCode) && !is_string($statusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusCode, true), gettype($statusCode)), __LINE__);
        }
        $this->StatusCode = $statusCode;
        return $this;
    }
    /**
     * Get Shop value
     * @return string|null
     */
    public function getShop()
    {
        return $this->Shop;
    }
    /**
     * Set Shop value
     * @param string $shop
     * @return \Geniki\GenikiStruct\GenikiCheckpoint
     */
    public function setShop($shop = null)
    {
        // validation for constraint: string
        if (!is_null($shop) && !is_string($shop)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shop, true), gettype($shop)), __LINE__);
        }
        $this->Shop = $shop;
        return $this;
    }
}
