<?php

namespace Geniki\GenikiStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MethodResult GenikiStruct
 * @package Geniki
 * @subpackage Structs
 */
class GenikiMethodResult extends AbstractStructBase
{
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Result;
    /**
     * Constructor method for MethodResult
     * @uses GenikiMethodResult::setResult()
     * @param int $result
     */
    public function __construct($result = null)
    {
        $this
            ->setResult($result);
    }
    /**
     * Get Result value
     * @return int
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param int $result
     * @return \Geniki\GenikiStruct\GenikiMethodResult
     */
    public function setResult($result = null)
    {
        // validation for constraint: int
        if (!is_null($result) && !(is_int($result) || ctype_digit($result))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($result, true), gettype($result)), __LINE__);
        }
        $this->Result = $result;
        return $this;
    }
}
