<?php

namespace Geniki\GenikiStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetJobsFromOrderId GenikiStruct
 * @package Geniki
 * @subpackage Structs
 */
class GenikiGetJobsFromOrderId extends AbstractStructBase
{
    /**
     * The sAuthKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sAuthKey;
    /**
     * The sOrderId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sOrderId;
    /**
     * Constructor method for GetJobsFromOrderId
     * @uses GenikiGetJobsFromOrderId::setSAuthKey()
     * @uses GenikiGetJobsFromOrderId::setSOrderId()
     * @param string $sAuthKey
     * @param string $sOrderId
     */
    public function __construct($sAuthKey = null, $sOrderId = null)
    {
        $this
            ->setSAuthKey($sAuthKey)
            ->setSOrderId($sOrderId);
    }
    /**
     * Get sAuthKey value
     * @return string|null
     */
    public function getSAuthKey()
    {
        return $this->sAuthKey;
    }
    /**
     * Set sAuthKey value
     * @param string $sAuthKey
     * @return \Geniki\GenikiStruct\GenikiGetJobsFromOrderId
     */
    public function setSAuthKey($sAuthKey = null)
    {
        // validation for constraint: string
        if (!is_null($sAuthKey) && !is_string($sAuthKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sAuthKey, true), gettype($sAuthKey)), __LINE__);
        }
        $this->sAuthKey = $sAuthKey;
        return $this;
    }
    /**
     * Get sOrderId value
     * @return string|null
     */
    public function getSOrderId()
    {
        return $this->sOrderId;
    }
    /**
     * Set sOrderId value
     * @param string $sOrderId
     * @return \Geniki\GenikiStruct\GenikiGetJobsFromOrderId
     */
    public function setSOrderId($sOrderId = null)
    {
        // validation for constraint: string
        if (!is_null($sOrderId) && !is_string($sOrderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sOrderId, true), gettype($sOrderId)), __LINE__);
        }
        $this->sOrderId = $sOrderId;
        return $this;
    }
}
