<?php

namespace Geniki\GenikiService;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Add GenikiService
 * @package Geniki
 * @subpackage Services
 */
class GenikiAdd extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AddJobReport
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Geniki\GenikiStruct\GenikiAddJobReport $parameters
     * @return \Geniki\GenikiStruct\GenikiAddJobReportResponse|bool
     */
    public function AddJobReport(\Geniki\GenikiStruct\GenikiAddJobReport $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddJobReport($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddExtraInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Geniki\GenikiStruct\GenikiAddExtraInfo $parameters
     * @return \Geniki\GenikiStruct\GenikiAddExtraInfoResponse|bool
     */
    public function AddExtraInfo(\Geniki\GenikiStruct\GenikiAddExtraInfo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddExtraInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Geniki\GenikiStruct\GenikiAddExtraInfoResponse|\Geniki\GenikiStruct\GenikiAddJobReportResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
