<?php

namespace Geniki\GenikiStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VoucherPickupOrder GenikiStruct
 * @package Geniki
 * @subpackage Structs
 */
class GenikiVoucherPickupOrder extends AbstractStructBase
{
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsActive;
    /**
     * The PickupDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PickupDate;
    /**
     * The DayQuarter
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DayQuarter;
    /**
     * The IsFinalized
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsFinalized;
    /**
     * The FinalizedAt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $FinalizedAt;
    /**
     * The VoucherNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VoucherNumber;
    /**
     * The UniqueID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UniqueID;
    /**
     * The ClientCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientCode;
    /**
     * Constructor method for VoucherPickupOrder
     * @uses GenikiVoucherPickupOrder::setIsActive()
     * @uses GenikiVoucherPickupOrder::setPickupDate()
     * @uses GenikiVoucherPickupOrder::setDayQuarter()
     * @uses GenikiVoucherPickupOrder::setIsFinalized()
     * @uses GenikiVoucherPickupOrder::setFinalizedAt()
     * @uses GenikiVoucherPickupOrder::setVoucherNumber()
     * @uses GenikiVoucherPickupOrder::setUniqueID()
     * @uses GenikiVoucherPickupOrder::setClientCode()
     * @param bool $isActive
     * @param string $pickupDate
     * @param string $dayQuarter
     * @param bool $isFinalized
     * @param string $finalizedAt
     * @param string $voucherNumber
     * @param string $uniqueID
     * @param string $clientCode
     */
    public function __construct($isActive = null, $pickupDate = null, $dayQuarter = null, $isFinalized = null, $finalizedAt = null, $voucherNumber = null, $uniqueID = null, $clientCode = null)
    {
        $this
            ->setIsActive($isActive)
            ->setPickupDate($pickupDate)
            ->setDayQuarter($dayQuarter)
            ->setIsFinalized($isFinalized)
            ->setFinalizedAt($finalizedAt)
            ->setVoucherNumber($voucherNumber)
            ->setUniqueID($uniqueID)
            ->setClientCode($clientCode);
    }
    /**
     * Get IsActive value
     * @return bool
     */
    public function getIsActive()
    {
        return $this->IsActive;
    }
    /**
     * Set IsActive value
     * @param bool $isActive
     * @return \Geniki\GenikiStruct\GenikiVoucherPickupOrder
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        $this->IsActive = $isActive;
        return $this;
    }
    /**
     * Get PickupDate value
     * @return string
     */
    public function getPickupDate()
    {
        return $this->PickupDate;
    }
    /**
     * Set PickupDate value
     * @param string $pickupDate
     * @return \Geniki\GenikiStruct\GenikiVoucherPickupOrder
     */
    public function setPickupDate($pickupDate = null)
    {
        // validation for constraint: string
        if (!is_null($pickupDate) && !is_string($pickupDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupDate, true), gettype($pickupDate)), __LINE__);
        }
        $this->PickupDate = $pickupDate;
        return $this;
    }
    /**
     * Get DayQuarter value
     * @return string
     */
    public function getDayQuarter()
    {
        return $this->DayQuarter;
    }
    /**
     * Set DayQuarter value
     * @uses \Geniki\GenikiEnum\GenikiDayQuarter::valueIsValid()
     * @uses \Geniki\GenikiEnum\GenikiDayQuarter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dayQuarter
     * @return \Geniki\GenikiStruct\GenikiVoucherPickupOrder
     */
    public function setDayQuarter($dayQuarter = null)
    {
        // validation for constraint: enumeration
        if (!\Geniki\GenikiEnum\GenikiDayQuarter::valueIsValid($dayQuarter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Geniki\GenikiEnum\GenikiDayQuarter', is_array($dayQuarter) ? implode(', ', $dayQuarter) : var_export($dayQuarter, true), implode(', ', \Geniki\GenikiEnum\GenikiDayQuarter::getValidValues())), __LINE__);
        }
        $this->DayQuarter = $dayQuarter;
        return $this;
    }
    /**
     * Get IsFinalized value
     * @return bool
     */
    public function getIsFinalized()
    {
        return $this->IsFinalized;
    }
    /**
     * Set IsFinalized value
     * @param bool $isFinalized
     * @return \Geniki\GenikiStruct\GenikiVoucherPickupOrder
     */
    public function setIsFinalized($isFinalized = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFinalized) && !is_bool($isFinalized)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isFinalized, true), gettype($isFinalized)), __LINE__);
        }
        $this->IsFinalized = $isFinalized;
        return $this;
    }
    /**
     * Get FinalizedAt value
     * @return string
     */
    public function getFinalizedAt()
    {
        return $this->FinalizedAt;
    }
    /**
     * Set FinalizedAt value
     * @param string $finalizedAt
     * @return \Geniki\GenikiStruct\GenikiVoucherPickupOrder
     */
    public function setFinalizedAt($finalizedAt = null)
    {
        // validation for constraint: string
        if (!is_null($finalizedAt) && !is_string($finalizedAt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($finalizedAt, true), gettype($finalizedAt)), __LINE__);
        }
        $this->FinalizedAt = $finalizedAt;
        return $this;
    }
    /**
     * Get VoucherNumber value
     * @return string|null
     */
    public function getVoucherNumber()
    {
        return $this->VoucherNumber;
    }
    /**
     * Set VoucherNumber value
     * @param string $voucherNumber
     * @return \Geniki\GenikiStruct\GenikiVoucherPickupOrder
     */
    public function setVoucherNumber($voucherNumber = null)
    {
        // validation for constraint: string
        if (!is_null($voucherNumber) && !is_string($voucherNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($voucherNumber, true), gettype($voucherNumber)), __LINE__);
        }
        $this->VoucherNumber = $voucherNumber;
        return $this;
    }
    /**
     * Get UniqueID value
     * @return string|null
     */
    public function getUniqueID()
    {
        return $this->UniqueID;
    }
    /**
     * Set UniqueID value
     * @param string $uniqueID
     * @return \Geniki\GenikiStruct\GenikiVoucherPickupOrder
     */
    public function setUniqueID($uniqueID = null)
    {
        // validation for constraint: string
        if (!is_null($uniqueID) && !is_string($uniqueID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uniqueID, true), gettype($uniqueID)), __LINE__);
        }
        $this->UniqueID = $uniqueID;
        return $this;
    }
    /**
     * Get ClientCode value
     * @return string|null
     */
    public function getClientCode()
    {
        return $this->ClientCode;
    }
    /**
     * Set ClientCode value
     * @param string $clientCode
     * @return \Geniki\GenikiStruct\GenikiVoucherPickupOrder
     */
    public function setClientCode($clientCode = null)
    {
        // validation for constraint: string
        if (!is_null($clientCode) && !is_string($clientCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientCode, true), gettype($clientCode)), __LINE__);
        }
        $this->ClientCode = $clientCode;
        return $this;
    }
}
