<?php

namespace Geniki\GenikiStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetReturnRequestResult GenikiStruct
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetReturnRequestResult
 * @package Geniki
 * @subpackage Structs
 */
class GenikiGetReturnRequestResult extends GenikiMethodResult
{
    /**
     * The DaysValid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DaysValid;
    /**
     * The IsPayedBySender
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsPayedBySender;
    /**
     * The CreatedOn
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreatedOn;
    /**
     * The ReturnedOn
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ReturnedOn;
    /**
     * The ReturnSerial
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReturnSerial;
    /**
     * The ReturnFrom
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReturnFrom;
    /**
     * The ReturnType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReturnType;
    /**
     * The Recipient
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Recipient;
    /**
     * The ReturningVoucher
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReturningVoucher;
    /**
     * Constructor method for GetReturnRequestResult
     * @uses GenikiGetReturnRequestResult::setDaysValid()
     * @uses GenikiGetReturnRequestResult::setIsPayedBySender()
     * @uses GenikiGetReturnRequestResult::setCreatedOn()
     * @uses GenikiGetReturnRequestResult::setReturnedOn()
     * @uses GenikiGetReturnRequestResult::setReturnSerial()
     * @uses GenikiGetReturnRequestResult::setReturnFrom()
     * @uses GenikiGetReturnRequestResult::setReturnType()
     * @uses GenikiGetReturnRequestResult::setRecipient()
     * @uses GenikiGetReturnRequestResult::setReturningVoucher()
     * @param int $daysValid
     * @param bool $isPayedBySender
     * @param string $createdOn
     * @param string $returnedOn
     * @param string $returnSerial
     * @param string $returnFrom
     * @param string $returnType
     * @param string $recipient
     * @param string $returningVoucher
     */
    public function __construct($daysValid = null, $isPayedBySender = null, $createdOn = null, $returnedOn = null, $returnSerial = null, $returnFrom = null, $returnType = null, $recipient = null, $returningVoucher = null)
    {
        $this
            ->setDaysValid($daysValid)
            ->setIsPayedBySender($isPayedBySender)
            ->setCreatedOn($createdOn)
            ->setReturnedOn($returnedOn)
            ->setReturnSerial($returnSerial)
            ->setReturnFrom($returnFrom)
            ->setReturnType($returnType)
            ->setRecipient($recipient)
            ->setReturningVoucher($returningVoucher);
    }
    /**
     * Get DaysValid value
     * @return int
     */
    public function getDaysValid()
    {
        return $this->DaysValid;
    }
    /**
     * Set DaysValid value
     * @param int $daysValid
     * @return \Geniki\GenikiStruct\GenikiGetReturnRequestResult
     */
    public function setDaysValid($daysValid = null)
    {
        // validation for constraint: int
        if (!is_null($daysValid) && !(is_int($daysValid) || ctype_digit($daysValid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($daysValid, true), gettype($daysValid)), __LINE__);
        }
        $this->DaysValid = $daysValid;
        return $this;
    }
    /**
     * Get IsPayedBySender value
     * @return bool
     */
    public function getIsPayedBySender()
    {
        return $this->IsPayedBySender;
    }
    /**
     * Set IsPayedBySender value
     * @param bool $isPayedBySender
     * @return \Geniki\GenikiStruct\GenikiGetReturnRequestResult
     */
    public function setIsPayedBySender($isPayedBySender = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPayedBySender) && !is_bool($isPayedBySender)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPayedBySender, true), gettype($isPayedBySender)), __LINE__);
        }
        $this->IsPayedBySender = $isPayedBySender;
        return $this;
    }
    /**
     * Get CreatedOn value
     * @return string
     */
    public function getCreatedOn()
    {
        return $this->CreatedOn;
    }
    /**
     * Set CreatedOn value
     * @param string $createdOn
     * @return \Geniki\GenikiStruct\GenikiGetReturnRequestResult
     */
    public function setCreatedOn($createdOn = null)
    {
        // validation for constraint: string
        if (!is_null($createdOn) && !is_string($createdOn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdOn, true), gettype($createdOn)), __LINE__);
        }
        $this->CreatedOn = $createdOn;
        return $this;
    }
    /**
     * Get ReturnedOn value
     * @return string
     */
    public function getReturnedOn()
    {
        return $this->ReturnedOn;
    }
    /**
     * Set ReturnedOn value
     * @param string $returnedOn
     * @return \Geniki\GenikiStruct\GenikiGetReturnRequestResult
     */
    public function setReturnedOn($returnedOn = null)
    {
        // validation for constraint: string
        if (!is_null($returnedOn) && !is_string($returnedOn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnedOn, true), gettype($returnedOn)), __LINE__);
        }
        $this->ReturnedOn = $returnedOn;
        return $this;
    }
    /**
     * Get ReturnSerial value
     * @return string|null
     */
    public function getReturnSerial()
    {
        return $this->ReturnSerial;
    }
    /**
     * Set ReturnSerial value
     * @param string $returnSerial
     * @return \Geniki\GenikiStruct\GenikiGetReturnRequestResult
     */
    public function setReturnSerial($returnSerial = null)
    {
        // validation for constraint: string
        if (!is_null($returnSerial) && !is_string($returnSerial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnSerial, true), gettype($returnSerial)), __LINE__);
        }
        $this->ReturnSerial = $returnSerial;
        return $this;
    }
    /**
     * Get ReturnFrom value
     * @return string|null
     */
    public function getReturnFrom()
    {
        return $this->ReturnFrom;
    }
    /**
     * Set ReturnFrom value
     * @param string $returnFrom
     * @return \Geniki\GenikiStruct\GenikiGetReturnRequestResult
     */
    public function setReturnFrom($returnFrom = null)
    {
        // validation for constraint: string
        if (!is_null($returnFrom) && !is_string($returnFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnFrom, true), gettype($returnFrom)), __LINE__);
        }
        $this->ReturnFrom = $returnFrom;
        return $this;
    }
    /**
     * Get ReturnType value
     * @return string|null
     */
    public function getReturnType()
    {
        return $this->ReturnType;
    }
    /**
     * Set ReturnType value
     * @param string $returnType
     * @return \Geniki\GenikiStruct\GenikiGetReturnRequestResult
     */
    public function setReturnType($returnType = null)
    {
        // validation for constraint: string
        if (!is_null($returnType) && !is_string($returnType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnType, true), gettype($returnType)), __LINE__);
        }
        $this->ReturnType = $returnType;
        return $this;
    }
    /**
     * Get Recipient value
     * @return string|null
     */
    public function getRecipient()
    {
        return $this->Recipient;
    }
    /**
     * Set Recipient value
     * @param string $recipient
     * @return \Geniki\GenikiStruct\GenikiGetReturnRequestResult
     */
    public function setRecipient($recipient = null)
    {
        // validation for constraint: string
        if (!is_null($recipient) && !is_string($recipient)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recipient, true), gettype($recipient)), __LINE__);
        }
        $this->Recipient = $recipient;
        return $this;
    }
    /**
     * Get ReturningVoucher value
     * @return string|null
     */
    public function getReturningVoucher()
    {
        return $this->ReturningVoucher;
    }
    /**
     * Set ReturningVoucher value
     * @param string $returningVoucher
     * @return \Geniki\GenikiStruct\GenikiGetReturnRequestResult
     */
    public function setReturningVoucher($returningVoucher = null)
    {
        // validation for constraint: string
        if (!is_null($returningVoucher) && !is_string($returningVoucher)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returningVoucher, true), gettype($returningVoucher)), __LINE__);
        }
        $this->ReturningVoucher = $returningVoucher;
        return $this;
    }
}
