<?php

namespace Geniki\GenikiStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetReturnRequest GenikiStruct
 * @package Geniki
 * @subpackage Structs
 */
class GenikiGetReturnRequest extends AbstractStructBase
{
    /**
     * The sAuthKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sAuthKey;
    /**
     * The returnSerial
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $returnSerial;
    /**
     * Constructor method for GetReturnRequest
     * @uses GenikiGetReturnRequest::setSAuthKey()
     * @uses GenikiGetReturnRequest::setReturnSerial()
     * @param string $sAuthKey
     * @param string $returnSerial
     */
    public function __construct($sAuthKey = null, $returnSerial = null)
    {
        $this
            ->setSAuthKey($sAuthKey)
            ->setReturnSerial($returnSerial);
    }
    /**
     * Get sAuthKey value
     * @return string|null
     */
    public function getSAuthKey()
    {
        return $this->sAuthKey;
    }
    /**
     * Set sAuthKey value
     * @param string $sAuthKey
     * @return \Geniki\GenikiStruct\GenikiGetReturnRequest
     */
    public function setSAuthKey($sAuthKey = null)
    {
        // validation for constraint: string
        if (!is_null($sAuthKey) && !is_string($sAuthKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sAuthKey, true), gettype($sAuthKey)), __LINE__);
        }
        $this->sAuthKey = $sAuthKey;
        return $this;
    }
    /**
     * Get returnSerial value
     * @return string|null
     */
    public function getReturnSerial()
    {
        return $this->returnSerial;
    }
    /**
     * Set returnSerial value
     * @param string $returnSerial
     * @return \Geniki\GenikiStruct\GenikiGetReturnRequest
     */
    public function setReturnSerial($returnSerial = null)
    {
        // validation for constraint: string
        if (!is_null($returnSerial) && !is_string($returnSerial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnSerial, true), gettype($returnSerial)), __LINE__);
        }
        $this->returnSerial = $returnSerial;
        return $this;
    }
}
