<?php

namespace Geniki\GenikiStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateGroupedVoucherJobResult GenikiStruct
 * @package Geniki
 * @subpackage Structs
 */
class GenikiCreateGroupedVoucherJobResult extends GenikiJobMethodResult
{
    /**
     * The Voucher
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Voucher;
    /**
     * The GroupedVouchers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Geniki\GenikiArray\GenikiArrayOfGroupingRecord
     */
    public $GroupedVouchers;
    /**
     * Constructor method for CreateGroupedVoucherJobResult
     * @uses GenikiCreateGroupedVoucherJobResult::setVoucher()
     * @uses GenikiCreateGroupedVoucherJobResult::setGroupedVouchers()
     * @param string $voucher
     * @param \Geniki\GenikiArray\GenikiArrayOfGroupingRecord $groupedVouchers
     */
    public function __construct($voucher = null, \Geniki\GenikiArray\GenikiArrayOfGroupingRecord $groupedVouchers = null)
    {
        $this
            ->setVoucher($voucher)
            ->setGroupedVouchers($groupedVouchers);
    }
    /**
     * Get Voucher value
     * @return string|null
     */
    public function getVoucher()
    {
        return $this->Voucher;
    }
    /**
     * Set Voucher value
     * @param string $voucher
     * @return \Geniki\GenikiStruct\GenikiCreateGroupedVoucherJobResult
     */
    public function setVoucher($voucher = null)
    {
        // validation for constraint: string
        if (!is_null($voucher) && !is_string($voucher)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($voucher, true), gettype($voucher)), __LINE__);
        }
        $this->Voucher = $voucher;
        return $this;
    }
    /**
     * Get GroupedVouchers value
     * @return \Geniki\GenikiArray\GenikiArrayOfGroupingRecord|null
     */
    public function getGroupedVouchers()
    {
        return $this->GroupedVouchers;
    }
    /**
     * Set GroupedVouchers value
     * @param \Geniki\GenikiArray\GenikiArrayOfGroupingRecord $groupedVouchers
     * @return \Geniki\GenikiStruct\GenikiCreateGroupedVoucherJobResult
     */
    public function setGroupedVouchers(\Geniki\GenikiArray\GenikiArrayOfGroupingRecord $groupedVouchers = null)
    {
        $this->GroupedVouchers = $groupedVouchers;
        return $this;
    }
}
