<?php

namespace Geniki\GenikiStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddJobReport GenikiStruct
 * @package Geniki
 * @subpackage Structs
 */
class GenikiAddJobReport extends AbstractStructBase
{
    /**
     * The nJobId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $nJobId;
    /**
     * The sAuthKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sAuthKey;
    /**
     * The sOrderId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sOrderId;
    /**
     * Constructor method for AddJobReport
     * @uses GenikiAddJobReport::setNJobId()
     * @uses GenikiAddJobReport::setSAuthKey()
     * @uses GenikiAddJobReport::setSOrderId()
     * @param int $nJobId
     * @param string $sAuthKey
     * @param string $sOrderId
     */
    public function __construct($nJobId = null, $sAuthKey = null, $sOrderId = null)
    {
        $this
            ->setNJobId($nJobId)
            ->setSAuthKey($sAuthKey)
            ->setSOrderId($sOrderId);
    }
    /**
     * Get nJobId value
     * @return int
     */
    public function getNJobId()
    {
        return $this->nJobId;
    }
    /**
     * Set nJobId value
     * @param int $nJobId
     * @return \Geniki\GenikiStruct\GenikiAddJobReport
     */
    public function setNJobId($nJobId = null)
    {
        // validation for constraint: int
        if (!is_null($nJobId) && !(is_int($nJobId) || ctype_digit($nJobId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nJobId, true), gettype($nJobId)), __LINE__);
        }
        $this->nJobId = $nJobId;
        return $this;
    }
    /**
     * Get sAuthKey value
     * @return string|null
     */
    public function getSAuthKey()
    {
        return $this->sAuthKey;
    }
    /**
     * Set sAuthKey value
     * @param string $sAuthKey
     * @return \Geniki\GenikiStruct\GenikiAddJobReport
     */
    public function setSAuthKey($sAuthKey = null)
    {
        // validation for constraint: string
        if (!is_null($sAuthKey) && !is_string($sAuthKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sAuthKey, true), gettype($sAuthKey)), __LINE__);
        }
        $this->sAuthKey = $sAuthKey;
        return $this;
    }
    /**
     * Get sOrderId value
     * @return string|null
     */
    public function getSOrderId()
    {
        return $this->sOrderId;
    }
    /**
     * Set sOrderId value
     * @param string $sOrderId
     * @return \Geniki\GenikiStruct\GenikiAddJobReport
     */
    public function setSOrderId($sOrderId = null)
    {
        // validation for constraint: string
        if (!is_null($sOrderId) && !is_string($sOrderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sOrderId, true), gettype($sOrderId)), __LINE__);
        }
        $this->sOrderId = $sOrderId;
        return $this;
    }
}
