<?php

namespace Geniki\GenikiService;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Create GenikiService
 * @package Geniki
 * @subpackage Services
 */
class GenikiCreate extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CreateClientVoucherJob
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Geniki\GenikiStruct\GenikiCreateClientVoucherJob $parameters
     * @return \Geniki\GenikiStruct\GenikiCreateClientVoucherJobResponse|bool
     */
    public function CreateClientVoucherJob(\Geniki\GenikiStruct\GenikiCreateClientVoucherJob $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateClientVoucherJob($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateGroupedVoucherJob
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Geniki\GenikiStruct\GenikiCreateGroupedVoucherJob $parameters
     * @return \Geniki\GenikiStruct\GenikiCreateGroupedVoucherJobResponse|bool
     */
    public function CreateGroupedVoucherJob(\Geniki\GenikiStruct\GenikiCreateGroupedVoucherJob $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateGroupedVoucherJob($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateReturnRequest
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Geniki\GenikiStruct\GenikiCreateReturnRequest $parameters
     * @return \Geniki\GenikiStruct\GenikiCreateReturnRequestResponse|bool
     */
    public function CreateReturnRequest(\Geniki\GenikiStruct\GenikiCreateReturnRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateReturnRequest($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateVoucherReturnRequest
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Geniki\GenikiStruct\GenikiCreateVoucherReturnRequest $parameters
     * @return \Geniki\GenikiStruct\GenikiCreateVoucherReturnRequestResponse|bool
     */
    public function CreateVoucherReturnRequest(\Geniki\GenikiStruct\GenikiCreateVoucherReturnRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateVoucherReturnRequest($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateCODRelease
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Geniki\GenikiStruct\GenikiCreateCODRelease $parameters
     * @return \Geniki\GenikiStruct\GenikiCreateCODReleaseResponse|bool
     */
    public function CreateCODRelease(\Geniki\GenikiStruct\GenikiCreateCODRelease $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateCODRelease($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateVoucherPickupOrder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Geniki\GenikiStruct\GenikiCreateVoucherPickupOrder $parameters
     * @return \Geniki\GenikiStruct\GenikiCreateVoucherPickupOrderResponse|bool
     */
    public function CreateVoucherPickupOrder(\Geniki\GenikiStruct\GenikiCreateVoucherPickupOrder $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateVoucherPickupOrder($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateVoucherReturnOrder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Geniki\GenikiStruct\GenikiCreateVoucherReturnOrder $parameters
     * @return \Geniki\GenikiStruct\GenikiCreateVoucherReturnOrderResponse|bool
     */
    public function CreateVoucherReturnOrder(\Geniki\GenikiStruct\GenikiCreateVoucherReturnOrder $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateVoucherReturnOrder($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateJob
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Geniki\GenikiStruct\GenikiCreateJob $parameters
     * @return \Geniki\GenikiStruct\GenikiCreateJobResponse|bool
     */
    public function CreateJob(\Geniki\GenikiStruct\GenikiCreateJob $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateJob($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Geniki\GenikiStruct\GenikiCreateClientVoucherJobResponse|\Geniki\GenikiStruct\GenikiCreateCODReleaseResponse|\Geniki\GenikiStruct\GenikiCreateGroupedVoucherJobResponse|\Geniki\GenikiStruct\GenikiCreateJobResponse|\Geniki\GenikiStruct\GenikiCreateReturnRequestResponse|\Geniki\GenikiStruct\GenikiCreateVoucherPickupOrderResponse|\Geniki\GenikiStruct\GenikiCreateVoucherReturnOrderResponse|\Geniki\GenikiStruct\GenikiCreateVoucherReturnRequestResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
