<?php

namespace Geniki\GenikiArray;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfGroupingRecord GenikiArray
 * @package Geniki
 * @subpackage Arrays
 */
class GenikiArrayOfGroupingRecord extends AbstractStructArrayBase
{
    /**
     * The GroupingRecord
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Geniki\GenikiStruct\GenikiGroupingRecord[]
     */
    public $GroupingRecord;
    /**
     * Constructor method for ArrayOfGroupingRecord
     * @uses GenikiArrayOfGroupingRecord::setGroupingRecord()
     * @param \Geniki\GenikiStruct\GenikiGroupingRecord[] $groupingRecord
     */
    public function __construct(array $groupingRecord = array())
    {
        $this
            ->setGroupingRecord($groupingRecord);
    }
    /**
     * Get GroupingRecord value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Geniki\GenikiStruct\GenikiGroupingRecord[]|null
     */
    public function getGroupingRecord()
    {
        return isset($this->GroupingRecord) ? $this->GroupingRecord : null;
    }
    /**
     * This method is responsible for validating the values passed to the setGroupingRecord method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGroupingRecord method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGroupingRecordForArrayConstraintsFromSetGroupingRecord(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfGroupingRecordGroupingRecordItem) {
            // validation for constraint: itemType
            if (!$arrayOfGroupingRecordGroupingRecordItem instanceof \Geniki\GenikiStruct\GenikiGroupingRecord) {
                $invalidValues[] = is_object($arrayOfGroupingRecordGroupingRecordItem) ? get_class($arrayOfGroupingRecordGroupingRecordItem) : sprintf('%s(%s)', gettype($arrayOfGroupingRecordGroupingRecordItem), var_export($arrayOfGroupingRecordGroupingRecordItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GroupingRecord property can only contain items of type \Geniki\GenikiStruct\GenikiGroupingRecord, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GroupingRecord value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Geniki\GenikiStruct\GenikiGroupingRecord[] $groupingRecord
     * @return \Geniki\GenikiArray\GenikiArrayOfGroupingRecord
     */
    public function setGroupingRecord(array $groupingRecord = array())
    {
        // validation for constraint: array
        if ('' !== ($groupingRecordArrayErrorMessage = self::validateGroupingRecordForArrayConstraintsFromSetGroupingRecord($groupingRecord))) {
            throw new \InvalidArgumentException($groupingRecordArrayErrorMessage, __LINE__);
        }
        if (is_null($groupingRecord) || (is_array($groupingRecord) && empty($groupingRecord))) {
            unset($this->GroupingRecord);
        } else {
            $this->GroupingRecord = $groupingRecord;
        }
        return $this;
    }
    /**
     * Add item to GroupingRecord value
     * @throws \InvalidArgumentException
     * @param \Geniki\GenikiStruct\GenikiGroupingRecord $item
     * @return \Geniki\GenikiArray\GenikiArrayOfGroupingRecord
     */
    public function addToGroupingRecord(\Geniki\GenikiStruct\GenikiGroupingRecord $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Geniki\GenikiStruct\GenikiGroupingRecord) {
            throw new \InvalidArgumentException(sprintf('The GroupingRecord property can only contain items of type \Geniki\GenikiStruct\GenikiGroupingRecord, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->GroupingRecord[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Geniki\GenikiStruct\GenikiGroupingRecord|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Geniki\GenikiStruct\GenikiGroupingRecord|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Geniki\GenikiStruct\GenikiGroupingRecord|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Geniki\GenikiStruct\GenikiGroupingRecord|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Geniki\GenikiStruct\GenikiGroupingRecord|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string GroupingRecord
     */
    public function getAttributeName()
    {
        return 'GroupingRecord';
    }
}
