<?php

namespace Geniki\GenikiStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ThirdPartyShipperDetails GenikiStruct
 * @package Geniki
 * @subpackage Structs
 */
class GenikiThirdPartyShipperDetails extends AbstractStructBase
{
    /**
     * The VatId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VatId;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address;
    /**
     * The City
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $City;
    /**
     * The Telephone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Telephone;
    /**
     * The Zip
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Zip;
    /**
     * Constructor method for ThirdPartyShipperDetails
     * @uses GenikiThirdPartyShipperDetails::setVatId()
     * @uses GenikiThirdPartyShipperDetails::setName()
     * @uses GenikiThirdPartyShipperDetails::setAddress()
     * @uses GenikiThirdPartyShipperDetails::setCity()
     * @uses GenikiThirdPartyShipperDetails::setTelephone()
     * @uses GenikiThirdPartyShipperDetails::setZip()
     * @param string $vatId
     * @param string $name
     * @param string $address
     * @param string $city
     * @param string $telephone
     * @param string $zip
     */
    public function __construct($vatId = null, $name = null, $address = null, $city = null, $telephone = null, $zip = null)
    {
        $this
            ->setVatId($vatId)
            ->setName($name)
            ->setAddress($address)
            ->setCity($city)
            ->setTelephone($telephone)
            ->setZip($zip);
    }
    /**
     * Get VatId value
     * @return string|null
     */
    public function getVatId()
    {
        return $this->VatId;
    }
    /**
     * Set VatId value
     * @param string $vatId
     * @return \Geniki\GenikiStruct\GenikiThirdPartyShipperDetails
     */
    public function setVatId($vatId = null)
    {
        // validation for constraint: string
        if (!is_null($vatId) && !is_string($vatId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vatId, true), gettype($vatId)), __LINE__);
        }
        $this->VatId = $vatId;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \Geniki\GenikiStruct\GenikiThirdPartyShipperDetails
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param string $address
     * @return \Geniki\GenikiStruct\GenikiThirdPartyShipperDetails
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address, true), gettype($address)), __LINE__);
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \Geniki\GenikiStruct\GenikiThirdPartyShipperDetails
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get Telephone value
     * @return string|null
     */
    public function getTelephone()
    {
        return $this->Telephone;
    }
    /**
     * Set Telephone value
     * @param string $telephone
     * @return \Geniki\GenikiStruct\GenikiThirdPartyShipperDetails
     */
    public function setTelephone($telephone = null)
    {
        // validation for constraint: string
        if (!is_null($telephone) && !is_string($telephone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($telephone, true), gettype($telephone)), __LINE__);
        }
        $this->Telephone = $telephone;
        return $this;
    }
    /**
     * Get Zip value
     * @return string|null
     */
    public function getZip()
    {
        return $this->Zip;
    }
    /**
     * Set Zip value
     * @param string $zip
     * @return \Geniki\GenikiStruct\GenikiThirdPartyShipperDetails
     */
    public function setZip($zip = null)
    {
        // validation for constraint: string
        if (!is_null($zip) && !is_string($zip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zip, true), gettype($zip)), __LINE__);
        }
        $this->Zip = $zip;
        return $this;
    }
}
