<?php

namespace Geniki\GenikiService;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Getrd GenikiService
 * @package Geniki
 * @subpackage Services
 */
class GenikiGetrd extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Get3rdPartyShipper
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Geniki\GenikiStruct\GenikiGet3rdPartyShipper $parameters
     * @return \Geniki\GenikiStruct\GenikiGet3rdPartyShipperResponse|bool
     */
    public function Get3rdPartyShipper(\Geniki\GenikiStruct\GenikiGet3rdPartyShipper $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Get3rdPartyShipper($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Geniki\GenikiStruct\GenikiGet3rdPartyShipperResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
