<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ZustaendigkeitTransferObjekt StructType
 * Meta information extracted from the WSDL
 * - documentation: Spezielles Transferobjekt für Zuständigkeiten. Dieses kann die ID des übergeordneten Objekts beinhalten.
 * @subpackage Structs
 */
class ZustaendigkeitTransferObjekt extends AbstractStructBase
{
    /**
     * The uebergeordnetesObjektID
     * Meta information extracted from the WSDL
     * - documentation: ID des übergeordneten Objekt, d.h. die ID der Organisationseinheit, des Onlinedienstes oder Person, welcher die Zuständigkeit zugeordnet ist.
     * - minOccurs: 0
     * @var \StructType\Identifikator
     */
    public $uebergeordnetesObjektID;
    /**
     * The zustaendigkeit
     * Meta information extracted from the WSDL
     * - documentation: Das eigentliche Zuständigkeitsobjekt (mit Ableitungen).
     * - maxOccurs: unbounded
     * @var \StructType\Zustaendigkeit[]
     */
    public $zustaendigkeit;
    /**
     * Constructor method for ZustaendigkeitTransferObjekt
     * @uses ZustaendigkeitTransferObjekt::setUebergeordnetesObjektID()
     * @uses ZustaendigkeitTransferObjekt::setZustaendigkeit()
     * @param \StructType\Identifikator $uebergeordnetesObjektID
     * @param \StructType\Zustaendigkeit[] $zustaendigkeit
     */
    public function __construct(\StructType\Identifikator $uebergeordnetesObjektID = null, array $zustaendigkeit = array())
    {
        $this
            ->setUebergeordnetesObjektID($uebergeordnetesObjektID)
            ->setZustaendigkeit($zustaendigkeit);
    }
    /**
     * Get uebergeordnetesObjektID value
     * @return \StructType\Identifikator|null
     */
    public function getUebergeordnetesObjektID()
    {
        return $this->uebergeordnetesObjektID;
    }
    /**
     * Set uebergeordnetesObjektID value
     * @param \StructType\Identifikator $uebergeordnetesObjektID
     * @return \StructType\ZustaendigkeitTransferObjekt
     */
    public function setUebergeordnetesObjektID(\StructType\Identifikator $uebergeordnetesObjektID = null)
    {
        $this->uebergeordnetesObjektID = $uebergeordnetesObjektID;
        return $this;
    }
    /**
     * Get zustaendigkeit value
     * @return \StructType\Zustaendigkeit[]|null
     */
    public function getZustaendigkeit()
    {
        return $this->zustaendigkeit;
    }
    /**
     * This method is responsible for validating the values passed to the setZustaendigkeit method
     * This method is willingly generated in order to preserve the one-line inline validation within the setZustaendigkeit method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateZustaendigkeitForArrayConstraintsFromSetZustaendigkeit(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $zustaendigkeitTransferObjektZustaendigkeitItem) {
            // validation for constraint: itemType
            if (!$zustaendigkeitTransferObjektZustaendigkeitItem instanceof \StructType\Zustaendigkeit) {
                $invalidValues[] = is_object($zustaendigkeitTransferObjektZustaendigkeitItem) ? get_class($zustaendigkeitTransferObjektZustaendigkeitItem) : sprintf('%s(%s)', gettype($zustaendigkeitTransferObjektZustaendigkeitItem), var_export($zustaendigkeitTransferObjektZustaendigkeitItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The zustaendigkeit property can only contain items of type \StructType\Zustaendigkeit, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set zustaendigkeit value
     * @throws \InvalidArgumentException
     * @param \StructType\Zustaendigkeit[] $zustaendigkeit
     * @return \StructType\ZustaendigkeitTransferObjekt
     */
    public function setZustaendigkeit(array $zustaendigkeit = array())
    {
        // validation for constraint: array
        if ('' !== ($zustaendigkeitArrayErrorMessage = self::validateZustaendigkeitForArrayConstraintsFromSetZustaendigkeit($zustaendigkeit))) {
            throw new \InvalidArgumentException($zustaendigkeitArrayErrorMessage, __LINE__);
        }
        $this->zustaendigkeit = $zustaendigkeit;
        return $this;
    }
    /**
     * Add item to zustaendigkeit value
     * @throws \InvalidArgumentException
     * @param \StructType\Zustaendigkeit $item
     * @return \StructType\ZustaendigkeitTransferObjekt
     */
    public function addToZustaendigkeit(\StructType\Zustaendigkeit $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Zustaendigkeit) {
            throw new \InvalidArgumentException(sprintf('The zustaendigkeit property can only contain items of type \StructType\Zustaendigkeit, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->zustaendigkeit[] = $item;
        return $this;
    }
}
