<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Zustaendigkeit StructType
 * Meta information extracted from the WSDL
 * - documentation: Zuständigkeit definiert die fachliche und räumliche Zuständigkeit unter optionaler Einbeziehung weiterer Kriterien. Es sollen Leistungen und Gebiete mit gleichen Zuständigkeitskriterien in einem Zustaendigkeitsobjekt
 * zusammengefasst werden.
 * @subpackage Structs
 */
class Zustaendigkeit extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - documentation: Optionale primäre ID.
     * - minOccurs: 0
     * @var \StructType\Identifikator
     */
    public $id;
    /**
     * The idSekundaer
     * Meta information extracted from the WSDL
     * - documentation: Sekundäre IDs.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Identifikator[]
     */
    public $idSekundaer;
    /**
     * The leistungID
     * Meta information extracted from the WSDL
     * - documentation: IDs der Leistungen, welche in dieser Zuständigkeit erbracht werden. Es sollen Leistungen und Gebiete mit gleichen Zuständigkeitskriterien in einem Zustaendigkeitsobjekt zusammengefasst werden.
     * - maxOccurs: unbounded
     * @var \StructType\Identifikator[]
     */
    public $leistungID;
    /**
     * The gebietID
     * Meta information extracted from the WSDL
     * - documentation: IDs der Gebiete, für welche die Leistungen erbracht werden.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Identifikator[]
     */
    public $gebietID;
    /**
     * The weitereInformation
     * Meta information extracted from the WSDL
     * - documentation: Weitere textuelle Angaben zur Zuständigkeit.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\String_Localized[]
     */
    public $weitereInformation;
    /**
     * The herausgeber
     * Meta information extracted from the WSDL
     * - documentation: Optionale Angabe des Herausgebers der Daten.
     * - minOccurs: 0
     * @var \StructType\Herausgeber
     */
    public $herausgeber;
    /**
     * The gueltigkeit
     * Meta information extracted from the WSDL
     * - documentation: Gueltigkeit definiert die Zeiträume in denen das Objekt gültig ist. Zeiträume können nacheinander liegen oder sich überschneiden.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Zeitraum[]
     */
    public $gueltigkeit;
    /**
     * Constructor method for Zustaendigkeit
     * @uses Zustaendigkeit::setId()
     * @uses Zustaendigkeit::setIdSekundaer()
     * @uses Zustaendigkeit::setLeistungID()
     * @uses Zustaendigkeit::setGebietID()
     * @uses Zustaendigkeit::setWeitereInformation()
     * @uses Zustaendigkeit::setHerausgeber()
     * @uses Zustaendigkeit::setGueltigkeit()
     * @param \StructType\Identifikator $id
     * @param \StructType\Identifikator[] $idSekundaer
     * @param \StructType\Identifikator[] $leistungID
     * @param \StructType\Identifikator[] $gebietID
     * @param \StructType\String_Localized[] $weitereInformation
     * @param \StructType\Herausgeber $herausgeber
     * @param \StructType\Zeitraum[] $gueltigkeit
     */
    public function __construct(\StructType\Identifikator $id = null, array $idSekundaer = array(), array $leistungID = array(), array $gebietID = array(), array $weitereInformation = array(), \StructType\Herausgeber $herausgeber = null, array $gueltigkeit = array())
    {
        $this
            ->setId($id)
            ->setIdSekundaer($idSekundaer)
            ->setLeistungID($leistungID)
            ->setGebietID($gebietID)
            ->setWeitereInformation($weitereInformation)
            ->setHerausgeber($herausgeber)
            ->setGueltigkeit($gueltigkeit);
    }
    /**
     * Get id value
     * @return \StructType\Identifikator|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param \StructType\Identifikator $id
     * @return \StructType\Zustaendigkeit
     */
    public function setId(\StructType\Identifikator $id = null)
    {
        $this->id = $id;
        return $this;
    }
    /**
     * Get idSekundaer value
     * @return \StructType\Identifikator[]|null
     */
    public function getIdSekundaer()
    {
        return $this->idSekundaer;
    }
    /**
     * This method is responsible for validating the values passed to the setIdSekundaer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIdSekundaer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIdSekundaerForArrayConstraintsFromSetIdSekundaer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $zustaendigkeitIdSekundaerItem) {
            // validation for constraint: itemType
            if (!$zustaendigkeitIdSekundaerItem instanceof \StructType\Identifikator) {
                $invalidValues[] = is_object($zustaendigkeitIdSekundaerItem) ? get_class($zustaendigkeitIdSekundaerItem) : sprintf('%s(%s)', gettype($zustaendigkeitIdSekundaerItem), var_export($zustaendigkeitIdSekundaerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The idSekundaer property can only contain items of type \StructType\Identifikator, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set idSekundaer value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator[] $idSekundaer
     * @return \StructType\Zustaendigkeit
     */
    public function setIdSekundaer(array $idSekundaer = array())
    {
        // validation for constraint: array
        if ('' !== ($idSekundaerArrayErrorMessage = self::validateIdSekundaerForArrayConstraintsFromSetIdSekundaer($idSekundaer))) {
            throw new \InvalidArgumentException($idSekundaerArrayErrorMessage, __LINE__);
        }
        $this->idSekundaer = $idSekundaer;
        return $this;
    }
    /**
     * Add item to idSekundaer value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator $item
     * @return \StructType\Zustaendigkeit
     */
    public function addToIdSekundaer(\StructType\Identifikator $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Identifikator) {
            throw new \InvalidArgumentException(sprintf('The idSekundaer property can only contain items of type \StructType\Identifikator, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->idSekundaer[] = $item;
        return $this;
    }
    /**
     * Get leistungID value
     * @return \StructType\Identifikator[]|null
     */
    public function getLeistungID()
    {
        return $this->leistungID;
    }
    /**
     * This method is responsible for validating the values passed to the setLeistungID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLeistungID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLeistungIDForArrayConstraintsFromSetLeistungID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $zustaendigkeitLeistungIDItem) {
            // validation for constraint: itemType
            if (!$zustaendigkeitLeistungIDItem instanceof \StructType\Identifikator) {
                $invalidValues[] = is_object($zustaendigkeitLeistungIDItem) ? get_class($zustaendigkeitLeistungIDItem) : sprintf('%s(%s)', gettype($zustaendigkeitLeistungIDItem), var_export($zustaendigkeitLeistungIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The leistungID property can only contain items of type \StructType\Identifikator, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set leistungID value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator[] $leistungID
     * @return \StructType\Zustaendigkeit
     */
    public function setLeistungID(array $leistungID = array())
    {
        // validation for constraint: array
        if ('' !== ($leistungIDArrayErrorMessage = self::validateLeistungIDForArrayConstraintsFromSetLeistungID($leistungID))) {
            throw new \InvalidArgumentException($leistungIDArrayErrorMessage, __LINE__);
        }
        $this->leistungID = $leistungID;
        return $this;
    }
    /**
     * Add item to leistungID value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator $item
     * @return \StructType\Zustaendigkeit
     */
    public function addToLeistungID(\StructType\Identifikator $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Identifikator) {
            throw new \InvalidArgumentException(sprintf('The leistungID property can only contain items of type \StructType\Identifikator, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->leistungID[] = $item;
        return $this;
    }
    /**
     * Get gebietID value
     * @return \StructType\Identifikator[]|null
     */
    public function getGebietID()
    {
        return $this->gebietID;
    }
    /**
     * This method is responsible for validating the values passed to the setGebietID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGebietID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGebietIDForArrayConstraintsFromSetGebietID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $zustaendigkeitGebietIDItem) {
            // validation for constraint: itemType
            if (!$zustaendigkeitGebietIDItem instanceof \StructType\Identifikator) {
                $invalidValues[] = is_object($zustaendigkeitGebietIDItem) ? get_class($zustaendigkeitGebietIDItem) : sprintf('%s(%s)', gettype($zustaendigkeitGebietIDItem), var_export($zustaendigkeitGebietIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The gebietID property can only contain items of type \StructType\Identifikator, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set gebietID value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator[] $gebietID
     * @return \StructType\Zustaendigkeit
     */
    public function setGebietID(array $gebietID = array())
    {
        // validation for constraint: array
        if ('' !== ($gebietIDArrayErrorMessage = self::validateGebietIDForArrayConstraintsFromSetGebietID($gebietID))) {
            throw new \InvalidArgumentException($gebietIDArrayErrorMessage, __LINE__);
        }
        $this->gebietID = $gebietID;
        return $this;
    }
    /**
     * Add item to gebietID value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator $item
     * @return \StructType\Zustaendigkeit
     */
    public function addToGebietID(\StructType\Identifikator $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Identifikator) {
            throw new \InvalidArgumentException(sprintf('The gebietID property can only contain items of type \StructType\Identifikator, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->gebietID[] = $item;
        return $this;
    }
    /**
     * Get weitereInformation value
     * @return \StructType\String_Localized[]|null
     */
    public function getWeitereInformation()
    {
        return $this->weitereInformation;
    }
    /**
     * This method is responsible for validating the values passed to the setWeitereInformation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWeitereInformation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWeitereInformationForArrayConstraintsFromSetWeitereInformation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $zustaendigkeitWeitereInformationItem) {
            // validation for constraint: itemType
            if (!$zustaendigkeitWeitereInformationItem instanceof \StructType\String_Localized) {
                $invalidValues[] = is_object($zustaendigkeitWeitereInformationItem) ? get_class($zustaendigkeitWeitereInformationItem) : sprintf('%s(%s)', gettype($zustaendigkeitWeitereInformationItem), var_export($zustaendigkeitWeitereInformationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The weitereInformation property can only contain items of type \StructType\String_Localized, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set weitereInformation value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized[] $weitereInformation
     * @return \StructType\Zustaendigkeit
     */
    public function setWeitereInformation(array $weitereInformation = array())
    {
        // validation for constraint: array
        if ('' !== ($weitereInformationArrayErrorMessage = self::validateWeitereInformationForArrayConstraintsFromSetWeitereInformation($weitereInformation))) {
            throw new \InvalidArgumentException($weitereInformationArrayErrorMessage, __LINE__);
        }
        $this->weitereInformation = $weitereInformation;
        return $this;
    }
    /**
     * Add item to weitereInformation value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized $item
     * @return \StructType\Zustaendigkeit
     */
    public function addToWeitereInformation(\StructType\String_Localized $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\String_Localized) {
            throw new \InvalidArgumentException(sprintf('The weitereInformation property can only contain items of type \StructType\String_Localized, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->weitereInformation[] = $item;
        return $this;
    }
    /**
     * Get herausgeber value
     * @return \StructType\Herausgeber|null
     */
    public function getHerausgeber()
    {
        return $this->herausgeber;
    }
    /**
     * Set herausgeber value
     * @param \StructType\Herausgeber $herausgeber
     * @return \StructType\Zustaendigkeit
     */
    public function setHerausgeber(\StructType\Herausgeber $herausgeber = null)
    {
        $this->herausgeber = $herausgeber;
        return $this;
    }
    /**
     * Get gueltigkeit value
     * @return \StructType\Zeitraum[]|null
     */
    public function getGueltigkeit()
    {
        return $this->gueltigkeit;
    }
    /**
     * This method is responsible for validating the values passed to the setGueltigkeit method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGueltigkeit method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGueltigkeitForArrayConstraintsFromSetGueltigkeit(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $zustaendigkeitGueltigkeitItem) {
            // validation for constraint: itemType
            if (!$zustaendigkeitGueltigkeitItem instanceof \StructType\Zeitraum) {
                $invalidValues[] = is_object($zustaendigkeitGueltigkeitItem) ? get_class($zustaendigkeitGueltigkeitItem) : sprintf('%s(%s)', gettype($zustaendigkeitGueltigkeitItem), var_export($zustaendigkeitGueltigkeitItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The gueltigkeit property can only contain items of type \StructType\Zeitraum, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set gueltigkeit value
     * @throws \InvalidArgumentException
     * @param \StructType\Zeitraum[] $gueltigkeit
     * @return \StructType\Zustaendigkeit
     */
    public function setGueltigkeit(array $gueltigkeit = array())
    {
        // validation for constraint: array
        if ('' !== ($gueltigkeitArrayErrorMessage = self::validateGueltigkeitForArrayConstraintsFromSetGueltigkeit($gueltigkeit))) {
            throw new \InvalidArgumentException($gueltigkeitArrayErrorMessage, __LINE__);
        }
        $this->gueltigkeit = $gueltigkeit;
        return $this;
    }
    /**
     * Add item to gueltigkeit value
     * @throws \InvalidArgumentException
     * @param \StructType\Zeitraum $item
     * @return \StructType\Zustaendigkeit
     */
    public function addToGueltigkeit(\StructType\Zeitraum $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Zeitraum) {
            throw new \InvalidArgumentException(sprintf('The gueltigkeit property can only contain items of type \StructType\Zeitraum, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->gueltigkeit[] = $item;
        return $this;
    }
}
