<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Zeitserien StructType
 * Meta information extracted from the WSDL
 * - documentation: Dieser Datentyp repräsentiert eine Menge an Regeln von Zeitserien bzw. Öffnungszeitelementen. Zudem können eine Menge von Sonderzeitserien angebunden werden, welche aus einem Beginn- und einem Enddatum sowie einem
 * Erläuterungstext bestehen.Unter Zeitserien können aber auch nur allgemein Hinweistexte wie Termine nur nach telefonischer Vereinbarung hinterlegt werden. Die Schließzeit ist die Abwesenheit von Öffnungszeiten im definierten Zeitraum. Spezielle
 * abweichende Zeiten, wie z.B. Feiertage, können über abweichende Zeiten und Angabe des Zusatzes angegeben werden.Das Modell orientiert sich am Entwurf des Datenmodells von Fokus Fraunhofer für verzeichnisbasierte Zuständigkeitsfinder.
 * @subpackage Structs
 */
class Zeitserien extends AbstractStructBase
{
    /**
     * The typ
     * Meta information extracted from the WSDL
     * - documentation: Der Zeitserientyp definiert spezielle Ausprägungen der Art der Zeitserie. Dies können z.B. allgemeine Öffnungszeiten, Besuchszeiten oder Servicezeiten sein. Wird kein spezieller Typ angegeben, ist von einer allgemeinen
     * Öffnungszeit auszugehen.
     * - minOccurs: 0
     * @var \StructType\Code_Zeitserientyp
     */
    public $typ;
    /**
     * The hinweistext
     * Meta information extracted from the WSDL
     * - documentation: Der Hinweistext repräsentiert eine allgemeine Beschreibung der Zeiten. Zum Beispiel könnten nur Termine nach telefonischer Anmeldung möglich sein.
     * - minOccurs: 0
     * @var \StructType\String_Localized
     */
    public $hinweistext;
    /**
     * The gueltigkeit
     * Meta information extracted from the WSDL
     * - documentation: Gueltigkeit definiert die Zeiträume in denen die Öffnungszeit gültig ist. Dies können sowohl nacheinander liegende oder überschneidende Zeiträume sein.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Zeitraum[]
     */
    public $gueltigkeit;
    /**
     * The regulaereZeiten
     * Meta information extracted from the WSDL
     * - documentation: Reguläre Zeiten definieren die regelmäßig wiederkehrende Erreichbarkeit als eine Menge von Zeitfenstern. Sie können im Einzelfall durch abweichende Zeiten erweitert oder eingeschränkt werden. Jedes Zeitfenster der regulären
     * Zeit kann in einem Zusatztext Einschränkungen wie z.B. nur für alleinerziehende Mütter definieren.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Zeitserie[]
     */
    public $regulaereZeiten;
    /**
     * The abweichendeZeiten
     * Meta information extracted from the WSDL
     * - documentation: Abweichende Zeiten definiert jeden Zeitraum der von der regulären Zeit abweicht. Dies können z.B. ergänzende Öffnungszeiten als auch Schließzeiten sein. Im Zusatz ist ein entsprechende Hinweis anzugeben.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Zeitraum[]
     */
    public $abweichendeZeiten;
    /**
     * Constructor method for Zeitserien
     * @uses Zeitserien::setTyp()
     * @uses Zeitserien::setHinweistext()
     * @uses Zeitserien::setGueltigkeit()
     * @uses Zeitserien::setRegulaereZeiten()
     * @uses Zeitserien::setAbweichendeZeiten()
     * @param \StructType\Code_Zeitserientyp $typ
     * @param \StructType\String_Localized $hinweistext
     * @param \StructType\Zeitraum[] $gueltigkeit
     * @param \StructType\Zeitserie[] $regulaereZeiten
     * @param \StructType\Zeitraum[] $abweichendeZeiten
     */
    public function __construct(\StructType\Code_Zeitserientyp $typ = null, \StructType\String_Localized $hinweistext = null, array $gueltigkeit = array(), array $regulaereZeiten = array(), array $abweichendeZeiten = array())
    {
        $this
            ->setTyp($typ)
            ->setHinweistext($hinweistext)
            ->setGueltigkeit($gueltigkeit)
            ->setRegulaereZeiten($regulaereZeiten)
            ->setAbweichendeZeiten($abweichendeZeiten);
    }
    /**
     * Get typ value
     * @return \StructType\Code_Zeitserientyp|null
     */
    public function getTyp()
    {
        return $this->typ;
    }
    /**
     * Set typ value
     * @param \StructType\Code_Zeitserientyp $typ
     * @return \StructType\Zeitserien
     */
    public function setTyp(\StructType\Code_Zeitserientyp $typ = null)
    {
        $this->typ = $typ;
        return $this;
    }
    /**
     * Get hinweistext value
     * @return \StructType\String_Localized|null
     */
    public function getHinweistext()
    {
        return $this->hinweistext;
    }
    /**
     * Set hinweistext value
     * @param \StructType\String_Localized $hinweistext
     * @return \StructType\Zeitserien
     */
    public function setHinweistext(\StructType\String_Localized $hinweistext = null)
    {
        $this->hinweistext = $hinweistext;
        return $this;
    }
    /**
     * Get gueltigkeit value
     * @return \StructType\Zeitraum[]|null
     */
    public function getGueltigkeit()
    {
        return $this->gueltigkeit;
    }
    /**
     * This method is responsible for validating the values passed to the setGueltigkeit method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGueltigkeit method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGueltigkeitForArrayConstraintsFromSetGueltigkeit(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $zeitserienGueltigkeitItem) {
            // validation for constraint: itemType
            if (!$zeitserienGueltigkeitItem instanceof \StructType\Zeitraum) {
                $invalidValues[] = is_object($zeitserienGueltigkeitItem) ? get_class($zeitserienGueltigkeitItem) : sprintf('%s(%s)', gettype($zeitserienGueltigkeitItem), var_export($zeitserienGueltigkeitItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The gueltigkeit property can only contain items of type \StructType\Zeitraum, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set gueltigkeit value
     * @throws \InvalidArgumentException
     * @param \StructType\Zeitraum[] $gueltigkeit
     * @return \StructType\Zeitserien
     */
    public function setGueltigkeit(array $gueltigkeit = array())
    {
        // validation for constraint: array
        if ('' !== ($gueltigkeitArrayErrorMessage = self::validateGueltigkeitForArrayConstraintsFromSetGueltigkeit($gueltigkeit))) {
            throw new \InvalidArgumentException($gueltigkeitArrayErrorMessage, __LINE__);
        }
        $this->gueltigkeit = $gueltigkeit;
        return $this;
    }
    /**
     * Add item to gueltigkeit value
     * @throws \InvalidArgumentException
     * @param \StructType\Zeitraum $item
     * @return \StructType\Zeitserien
     */
    public function addToGueltigkeit(\StructType\Zeitraum $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Zeitraum) {
            throw new \InvalidArgumentException(sprintf('The gueltigkeit property can only contain items of type \StructType\Zeitraum, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->gueltigkeit[] = $item;
        return $this;
    }
    /**
     * Get regulaereZeiten value
     * @return \StructType\Zeitserie[]|null
     */
    public function getRegulaereZeiten()
    {
        return $this->regulaereZeiten;
    }
    /**
     * This method is responsible for validating the values passed to the setRegulaereZeiten method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRegulaereZeiten method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRegulaereZeitenForArrayConstraintsFromSetRegulaereZeiten(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $zeitserienRegulaereZeitenItem) {
            // validation for constraint: itemType
            if (!$zeitserienRegulaereZeitenItem instanceof \StructType\Zeitserie) {
                $invalidValues[] = is_object($zeitserienRegulaereZeitenItem) ? get_class($zeitserienRegulaereZeitenItem) : sprintf('%s(%s)', gettype($zeitserienRegulaereZeitenItem), var_export($zeitserienRegulaereZeitenItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The regulaereZeiten property can only contain items of type \StructType\Zeitserie, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set regulaereZeiten value
     * @throws \InvalidArgumentException
     * @param \StructType\Zeitserie[] $regulaereZeiten
     * @return \StructType\Zeitserien
     */
    public function setRegulaereZeiten(array $regulaereZeiten = array())
    {
        // validation for constraint: array
        if ('' !== ($regulaereZeitenArrayErrorMessage = self::validateRegulaereZeitenForArrayConstraintsFromSetRegulaereZeiten($regulaereZeiten))) {
            throw new \InvalidArgumentException($regulaereZeitenArrayErrorMessage, __LINE__);
        }
        $this->regulaereZeiten = $regulaereZeiten;
        return $this;
    }
    /**
     * Add item to regulaereZeiten value
     * @throws \InvalidArgumentException
     * @param \StructType\Zeitserie $item
     * @return \StructType\Zeitserien
     */
    public function addToRegulaereZeiten(\StructType\Zeitserie $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Zeitserie) {
            throw new \InvalidArgumentException(sprintf('The regulaereZeiten property can only contain items of type \StructType\Zeitserie, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->regulaereZeiten[] = $item;
        return $this;
    }
    /**
     * Get abweichendeZeiten value
     * @return \StructType\Zeitraum[]|null
     */
    public function getAbweichendeZeiten()
    {
        return $this->abweichendeZeiten;
    }
    /**
     * This method is responsible for validating the values passed to the setAbweichendeZeiten method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAbweichendeZeiten method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAbweichendeZeitenForArrayConstraintsFromSetAbweichendeZeiten(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $zeitserienAbweichendeZeitenItem) {
            // validation for constraint: itemType
            if (!$zeitserienAbweichendeZeitenItem instanceof \StructType\Zeitraum) {
                $invalidValues[] = is_object($zeitserienAbweichendeZeitenItem) ? get_class($zeitserienAbweichendeZeitenItem) : sprintf('%s(%s)', gettype($zeitserienAbweichendeZeitenItem), var_export($zeitserienAbweichendeZeitenItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The abweichendeZeiten property can only contain items of type \StructType\Zeitraum, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set abweichendeZeiten value
     * @throws \InvalidArgumentException
     * @param \StructType\Zeitraum[] $abweichendeZeiten
     * @return \StructType\Zeitserien
     */
    public function setAbweichendeZeiten(array $abweichendeZeiten = array())
    {
        // validation for constraint: array
        if ('' !== ($abweichendeZeitenArrayErrorMessage = self::validateAbweichendeZeitenForArrayConstraintsFromSetAbweichendeZeiten($abweichendeZeiten))) {
            throw new \InvalidArgumentException($abweichendeZeitenArrayErrorMessage, __LINE__);
        }
        $this->abweichendeZeiten = $abweichendeZeiten;
        return $this;
    }
    /**
     * Add item to abweichendeZeiten value
     * @throws \InvalidArgumentException
     * @param \StructType\Zeitraum $item
     * @return \StructType\Zeitserien
     */
    public function addToAbweichendeZeiten(\StructType\Zeitraum $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Zeitraum) {
            throw new \InvalidArgumentException(sprintf('The abweichendeZeiten property can only contain items of type \StructType\Zeitraum, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->abweichendeZeiten[] = $item;
        return $this;
    }
}
