<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Zeitraum StructType
 * Meta information extracted from the WSDL
 * - documentation: Der Zeitraum kennzeichnet einen Abschnitt auf einem Zeitstrahl durch Angabe von Beginn und/oder Ende.
 * @subpackage Structs
 */
class Zeitraum extends AbstractStructBase
{
    /**
     * The beginn
     * Meta information extracted from the WSDL
     * - documentation: Der Beginn eines Zeitraums beschreibt den Zeitpunkt, ab dem ein Sachverhalt eintritt bzw. rechtskräftig wirksam ist. Der Beginn ist immer Teil der Dauer des Zeitraumes.
     * - minOccurs: 0
     * @var string
     */
    public $beginn;
    /**
     * The ende
     * Meta information extracted from the WSDL
     * - documentation: Das Ende eines Zeitraumes beschreibt den Zeitpunkt, ab dem ein Sachverhalt endet bzw. nicht mehr rechtskräftig ist. Das Ende ist Teil der Dauer des Zeitraumes.
     * - minOccurs: 0
     * @var string
     */
    public $ende;
    /**
     * The zusatz
     * Meta information extracted from the WSDL
     * - documentation: Der Zusatz enthält weitere textuelle Beschreibungen des festgelegten Zeitraums.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\String_Localized[]
     */
    public $zusatz;
    /**
     * Constructor method for Zeitraum
     * @uses Zeitraum::setBeginn()
     * @uses Zeitraum::setEnde()
     * @uses Zeitraum::setZusatz()
     * @param string $beginn
     * @param string $ende
     * @param \StructType\String_Localized[] $zusatz
     */
    public function __construct($beginn = null, $ende = null, array $zusatz = array())
    {
        $this
            ->setBeginn($beginn)
            ->setEnde($ende)
            ->setZusatz($zusatz);
    }
    /**
     * Get beginn value
     * @return string|null
     */
    public function getBeginn()
    {
        return $this->beginn;
    }
    /**
     * Set beginn value
     * @param string $beginn
     * @return \StructType\Zeitraum
     */
    public function setBeginn($beginn = null)
    {
        // validation for constraint: string
        if (!is_null($beginn) && !is_string($beginn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($beginn, true), gettype($beginn)), __LINE__);
        }
        $this->beginn = $beginn;
        return $this;
    }
    /**
     * Get ende value
     * @return string|null
     */
    public function getEnde()
    {
        return $this->ende;
    }
    /**
     * Set ende value
     * @param string $ende
     * @return \StructType\Zeitraum
     */
    public function setEnde($ende = null)
    {
        // validation for constraint: string
        if (!is_null($ende) && !is_string($ende)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ende, true), gettype($ende)), __LINE__);
        }
        $this->ende = $ende;
        return $this;
    }
    /**
     * Get zusatz value
     * @return \StructType\String_Localized[]|null
     */
    public function getZusatz()
    {
        return $this->zusatz;
    }
    /**
     * This method is responsible for validating the values passed to the setZusatz method
     * This method is willingly generated in order to preserve the one-line inline validation within the setZusatz method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateZusatzForArrayConstraintsFromSetZusatz(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $zeitraumZusatzItem) {
            // validation for constraint: itemType
            if (!$zeitraumZusatzItem instanceof \StructType\String_Localized) {
                $invalidValues[] = is_object($zeitraumZusatzItem) ? get_class($zeitraumZusatzItem) : sprintf('%s(%s)', gettype($zeitraumZusatzItem), var_export($zeitraumZusatzItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The zusatz property can only contain items of type \StructType\String_Localized, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set zusatz value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized[] $zusatz
     * @return \StructType\Zeitraum
     */
    public function setZusatz(array $zusatz = array())
    {
        // validation for constraint: array
        if ('' !== ($zusatzArrayErrorMessage = self::validateZusatzForArrayConstraintsFromSetZusatz($zusatz))) {
            throw new \InvalidArgumentException($zusatzArrayErrorMessage, __LINE__);
        }
        $this->zusatz = $zusatz;
        return $this;
    }
    /**
     * Add item to zusatz value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized $item
     * @return \StructType\Zeitraum
     */
    public function addToZusatz(\StructType\String_Localized $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\String_Localized) {
            throw new \InvalidArgumentException(sprintf('The zusatz property can only contain items of type \StructType\String_Localized, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->zusatz[] = $item;
        return $this;
    }
}
