<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VerwaltungspolitischeKodierung StructType
 * Meta information extracted from the WSDL
 * - documentation: Die Komponente "VerwaltungspolitischeKodierung" beinhaltet Informationen, die eine verwaltungspolitisch eindeutige Zuordnung in Deutschland ermöglichen.
 * @subpackage Structs
 */
class VerwaltungspolitischeKodierung extends AbstractStructBase
{
    /**
     * The kreis
     * Meta information extracted from the WSDL
     * - documentation: In Deutschland bezeichnet der Kreis eine bestimmte Region, einen Stadt- oder Landkreis.Die Bezeichnung eines Kreises erfolgt durch die Angabe eines Schlüssels zur Identifikation des Kreises innerhalb des Landes.
     * - minOccurs: 0
     * @var \StructType\Code_KreisDestatis
     */
    public $kreis;
    /**
     * The bezirk
     * Meta information extracted from the WSDL
     * - documentation: In Deutschland wird mit Bezirk eine bestimmte Region bezeichnet, die einem Regierungsbezirk, einem ehemaligen Regierungsbezirk oder einer anderen statistischen Einheit entspricht, die zwar mehrere Kreise umfasst, jedoch kleiner als
     * ein Bundesland ist.Die Bezeichnung eines Bezirks erfolgt durch die Angabe eines Schlüssels zur Identifikation des Bezirks innerhalb des Landes.
     * - minOccurs: 0
     * @var \StructType\Code_BezirkDestatis
     */
    public $bezirk;
    /**
     * The bundesland
     * Meta information extracted from the WSDL
     * - documentation: In Deutschland bezeichnet ein Bundesland eine bestimmte Region und umfasst mehrere Kreise und Bezirke (Ausnahme bilden die sogenannten Stadtstaaten).Die Bezeichnung eines Bundeslandes erfolgt durch die Angabe eines Schlüssels zur
     * Identifikation des Bundeslandes innerhalb des Landes.
     * - minOccurs: 0
     * @var \StructType\Code_BundeslandDestatis
     */
    public $bundesland;
    /**
     * The gemeindeschluessel
     * Meta information extracted from the WSDL
     * - documentation: Ein Gemeindeschlüssel ist ein Schlüssel zur Identifikation einer Gemeinde oder sonstiger Gebietskörperschaften (Kreis, Bezirk, Bundesland).
     * - minOccurs: 0
     * @var \StructType\Code_GemeindeschluesselDestatis
     */
    public $gemeindeschluessel;
    /**
     * The regionalschluessel
     * Meta information extracted from the WSDL
     * - documentation: Ein Regionalschlüssel ist ein Schlüssel zur Identifikation einer Gemeinde oder sonstiger Gebietskörperschaften (Kreis, Bezirks, Bundesland).
     * - minOccurs: 0
     * @var \StructType\Code_RegionalschluesselDestatis
     */
    public $regionalschluessel;
    /**
     * The gemeindeteilschluessel
     * Meta information extracted from the WSDL
     * - documentation: Hier kann optional der Schlüssel / Code eines Gemeindeteils angegeben werden. Dieses Attribut ist nicht Teil der Kernkomponenten "Anschrift".
     * - minOccurs: 0
     * @var \StructType\Code_Gemeindeteilschluessel
     */
    public $gemeindeteilschluessel;
    /**
     * The staat
     * Meta information extracted from the WSDL
     * - documentation: Das Attribut nation aus den VerwaltungspolitischeKodierung aus den Kernkomponenten wird hier als staat benannt und referenziert direkt die Codeliste von Destatis - ohne die redundante Zwischenklasse Staat aus den Kernkomponenten.
     * - minOccurs: 0
     * @var \StructType\Code_StaatDestatis
     */
    public $staat;
    /**
     * Constructor method for VerwaltungspolitischeKodierung
     * @uses VerwaltungspolitischeKodierung::setKreis()
     * @uses VerwaltungspolitischeKodierung::setBezirk()
     * @uses VerwaltungspolitischeKodierung::setBundesland()
     * @uses VerwaltungspolitischeKodierung::setGemeindeschluessel()
     * @uses VerwaltungspolitischeKodierung::setRegionalschluessel()
     * @uses VerwaltungspolitischeKodierung::setGemeindeteilschluessel()
     * @uses VerwaltungspolitischeKodierung::setStaat()
     * @param \StructType\Code_KreisDestatis $kreis
     * @param \StructType\Code_BezirkDestatis $bezirk
     * @param \StructType\Code_BundeslandDestatis $bundesland
     * @param \StructType\Code_GemeindeschluesselDestatis $gemeindeschluessel
     * @param \StructType\Code_RegionalschluesselDestatis $regionalschluessel
     * @param \StructType\Code_Gemeindeteilschluessel $gemeindeteilschluessel
     * @param \StructType\Code_StaatDestatis $staat
     */
    public function __construct(\StructType\Code_KreisDestatis $kreis = null, \StructType\Code_BezirkDestatis $bezirk = null, \StructType\Code_BundeslandDestatis $bundesland = null, \StructType\Code_GemeindeschluesselDestatis $gemeindeschluessel = null, \StructType\Code_RegionalschluesselDestatis $regionalschluessel = null, \StructType\Code_Gemeindeteilschluessel $gemeindeteilschluessel = null, \StructType\Code_StaatDestatis $staat = null)
    {
        $this
            ->setKreis($kreis)
            ->setBezirk($bezirk)
            ->setBundesland($bundesland)
            ->setGemeindeschluessel($gemeindeschluessel)
            ->setRegionalschluessel($regionalschluessel)
            ->setGemeindeteilschluessel($gemeindeteilschluessel)
            ->setStaat($staat);
    }
    /**
     * Get kreis value
     * @return \StructType\Code_KreisDestatis|null
     */
    public function getKreis()
    {
        return $this->kreis;
    }
    /**
     * Set kreis value
     * @param \StructType\Code_KreisDestatis $kreis
     * @return \StructType\VerwaltungspolitischeKodierung
     */
    public function setKreis(\StructType\Code_KreisDestatis $kreis = null)
    {
        $this->kreis = $kreis;
        return $this;
    }
    /**
     * Get bezirk value
     * @return \StructType\Code_BezirkDestatis|null
     */
    public function getBezirk()
    {
        return $this->bezirk;
    }
    /**
     * Set bezirk value
     * @param \StructType\Code_BezirkDestatis $bezirk
     * @return \StructType\VerwaltungspolitischeKodierung
     */
    public function setBezirk(\StructType\Code_BezirkDestatis $bezirk = null)
    {
        $this->bezirk = $bezirk;
        return $this;
    }
    /**
     * Get bundesland value
     * @return \StructType\Code_BundeslandDestatis|null
     */
    public function getBundesland()
    {
        return $this->bundesland;
    }
    /**
     * Set bundesland value
     * @param \StructType\Code_BundeslandDestatis $bundesland
     * @return \StructType\VerwaltungspolitischeKodierung
     */
    public function setBundesland(\StructType\Code_BundeslandDestatis $bundesland = null)
    {
        $this->bundesland = $bundesland;
        return $this;
    }
    /**
     * Get gemeindeschluessel value
     * @return \StructType\Code_GemeindeschluesselDestatis|null
     */
    public function getGemeindeschluessel()
    {
        return $this->gemeindeschluessel;
    }
    /**
     * Set gemeindeschluessel value
     * @param \StructType\Code_GemeindeschluesselDestatis $gemeindeschluessel
     * @return \StructType\VerwaltungspolitischeKodierung
     */
    public function setGemeindeschluessel(\StructType\Code_GemeindeschluesselDestatis $gemeindeschluessel = null)
    {
        $this->gemeindeschluessel = $gemeindeschluessel;
        return $this;
    }
    /**
     * Get regionalschluessel value
     * @return \StructType\Code_RegionalschluesselDestatis|null
     */
    public function getRegionalschluessel()
    {
        return $this->regionalschluessel;
    }
    /**
     * Set regionalschluessel value
     * @param \StructType\Code_RegionalschluesselDestatis $regionalschluessel
     * @return \StructType\VerwaltungspolitischeKodierung
     */
    public function setRegionalschluessel(\StructType\Code_RegionalschluesselDestatis $regionalschluessel = null)
    {
        $this->regionalschluessel = $regionalschluessel;
        return $this;
    }
    /**
     * Get gemeindeteilschluessel value
     * @return \StructType\Code_Gemeindeteilschluessel|null
     */
    public function getGemeindeteilschluessel()
    {
        return $this->gemeindeteilschluessel;
    }
    /**
     * Set gemeindeteilschluessel value
     * @param \StructType\Code_Gemeindeteilschluessel $gemeindeteilschluessel
     * @return \StructType\VerwaltungspolitischeKodierung
     */
    public function setGemeindeteilschluessel(\StructType\Code_Gemeindeteilschluessel $gemeindeteilschluessel = null)
    {
        $this->gemeindeteilschluessel = $gemeindeteilschluessel;
        return $this;
    }
    /**
     * Get staat value
     * @return \StructType\Code_StaatDestatis|null
     */
    public function getStaat()
    {
        return $this->staat;
    }
    /**
     * Set staat value
     * @param \StructType\Code_StaatDestatis $staat
     * @return \StructType\VerwaltungspolitischeKodierung
     */
    public function setStaat(\StructType\Code_StaatDestatis $staat = null)
    {
        $this->staat = $staat;
        return $this;
    }
}
