<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UrsprungsportalModul StructType
 * Meta information extracted from the WSDL
 * - documentation: Informationen zur Ansicht der Leistung im Ursprungsportal bzw. -system.
 * @subpackage Structs
 */
class UrsprungsportalModul extends Leistungsmodul
{
    /**
     * The uri
     * Meta information extracted from the WSDL
     * - documentation: URI des Links zum Ursprungsportal der Leistung.
     * @var string
     */
    public $uri;
    /**
     * The titel
     * Meta information extracted from the WSDL
     * - documentation: Optionaler Titel der URI
     * - minOccurs: 0
     * @var string
     */
    public $titel;
    /**
     * The languageCode
     * Meta information extracted from the WSDL
     * - documentation: Code der Sprache des Titels und/oder des Rücksprungziels. Abgebildet mit W3C-Datentyp xs:language (http://www.w3.org/TR/xmlschema-2/#language)
     * - use: optional
     * @var string
     */
    public $languageCode;
    /**
     * Constructor method for UrsprungsportalModul
     * @uses UrsprungsportalModul::setUri()
     * @uses UrsprungsportalModul::setTitel()
     * @uses UrsprungsportalModul::setLanguageCode()
     * @param string $uri
     * @param string $titel
     * @param string $languageCode
     */
    public function __construct($uri = null, $titel = null, $languageCode = null)
    {
        $this
            ->setUri($uri)
            ->setTitel($titel)
            ->setLanguageCode($languageCode);
    }
    /**
     * Get uri value
     * @return string|null
     */
    public function getUri()
    {
        return $this->uri;
    }
    /**
     * Set uri value
     * @param string $uri
     * @return \StructType\UrsprungsportalModul
     */
    public function setUri($uri = null)
    {
        // validation for constraint: string
        if (!is_null($uri) && !is_string($uri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uri, true), gettype($uri)), __LINE__);
        }
        $this->uri = $uri;
        return $this;
    }
    /**
     * Get titel value
     * @return string|null
     */
    public function getTitel()
    {
        return $this->titel;
    }
    /**
     * Set titel value
     * @param string $titel
     * @return \StructType\UrsprungsportalModul
     */
    public function setTitel($titel = null)
    {
        // validation for constraint: string
        if (!is_null($titel) && !is_string($titel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($titel, true), gettype($titel)), __LINE__);
        }
        $this->titel = $titel;
        return $this;
    }
    /**
     * Get languageCode value
     * @return string|null
     */
    public function getLanguageCode()
    {
        return $this->languageCode;
    }
    /**
     * Set languageCode value
     * @param string $languageCode
     * @return \StructType\UrsprungsportalModul
     */
    public function setLanguageCode($languageCode = null)
    {
        // validation for constraint: string
        if (!is_null($languageCode) && !is_string($languageCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($languageCode, true), gettype($languageCode)), __LINE__);
        }
        $this->languageCode = $languageCode;
        return $this;
    }
}
