<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnitDefinitionType StructType
 * @subpackage Structs
 */
class UnitDefinitionType extends AbstractStructBase
{
    /**
     * The quantityType
     * @var \StructType\StringOrRefType
     */
    public $quantityType;
    /**
     * The quantityTypeReference
     * @var \StructType\ReferenceType
     */
    public $quantityTypeReference;
    /**
     * The catalogSymbol
     * @var \StructType\CodeType
     */
    public $catalogSymbol;
    /**
     * Constructor method for UnitDefinitionType
     * @uses UnitDefinitionType::setQuantityType()
     * @uses UnitDefinitionType::setQuantityTypeReference()
     * @uses UnitDefinitionType::setCatalogSymbol()
     * @param \StructType\StringOrRefType $quantityType
     * @param \StructType\ReferenceType $quantityTypeReference
     * @param \StructType\CodeType $catalogSymbol
     */
    public function __construct(\StructType\StringOrRefType $quantityType = null, \StructType\ReferenceType $quantityTypeReference = null, \StructType\CodeType $catalogSymbol = null)
    {
        $this
            ->setQuantityType($quantityType)
            ->setQuantityTypeReference($quantityTypeReference)
            ->setCatalogSymbol($catalogSymbol);
    }
    /**
     * Get quantityType value
     * @return \StructType\StringOrRefType|null
     */
    public function getQuantityType()
    {
        return $this->quantityType;
    }
    /**
     * Set quantityType value
     * @param \StructType\StringOrRefType $quantityType
     * @return \StructType\UnitDefinitionType
     */
    public function setQuantityType(\StructType\StringOrRefType $quantityType = null)
    {
        $this->quantityType = $quantityType;
        return $this;
    }
    /**
     * Get quantityTypeReference value
     * @return \StructType\ReferenceType|null
     */
    public function getQuantityTypeReference()
    {
        return $this->quantityTypeReference;
    }
    /**
     * Set quantityTypeReference value
     * @param \StructType\ReferenceType $quantityTypeReference
     * @return \StructType\UnitDefinitionType
     */
    public function setQuantityTypeReference(\StructType\ReferenceType $quantityTypeReference = null)
    {
        $this->quantityTypeReference = $quantityTypeReference;
        return $this;
    }
    /**
     * Get catalogSymbol value
     * @return \StructType\CodeType|null
     */
    public function getCatalogSymbol()
    {
        return $this->catalogSymbol;
    }
    /**
     * Set catalogSymbol value
     * @param \StructType\CodeType $catalogSymbol
     * @return \StructType\UnitDefinitionType
     */
    public function setCatalogSymbol(\StructType\CodeType $catalogSymbol = null)
    {
        $this->catalogSymbol = $catalogSymbol;
        return $this;
    }
}
