<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for transfer.rueckantwort.040501 StructType
 * Meta information extracted from the WSDL
 * - documentation: Nachricht zur Übertragungen einer Rückanwort auf Transfer-Nachrichten.
 * @subpackage Structs
 */
class Transfer_rueckantwort_040501 extends Basisnachricht
{
    /**
     * The referenzierteNachrichtUUID
     * Meta information extracted from the WSDL
     * - documentation: UUID (Universally Unique Identifier) der Nachricht, auf welche hier die Rückantwort erfolgt.
     * @var string
     */
    public $referenzierteNachrichtUUID;
    /**
     * The antwortrueckgabecode
     * Meta information extracted from the WSDL
     * - documentation: Rückgabecode der Antwortnachricht
     * @var \StructType\Code_NachrichtAntwortCode
     */
    public $antwortrueckgabecode;
    /**
     * The antwortrueckgabezusatz
     * Meta information extracted from the WSDL
     * - documentation: Textuelle Zusatzinformationen zum Rückgabecode der Antwort.
     * - minOccurs: 0
     * @var string
     */
    public $antwortrueckgabezusatz;
    /**
     * Constructor method for transfer.rueckantwort.040501
     * @uses Transfer_rueckantwort_040501::setReferenzierteNachrichtUUID()
     * @uses Transfer_rueckantwort_040501::setAntwortrueckgabecode()
     * @uses Transfer_rueckantwort_040501::setAntwortrueckgabezusatz()
     * @param string $referenzierteNachrichtUUID
     * @param \StructType\Code_NachrichtAntwortCode $antwortrueckgabecode
     * @param string $antwortrueckgabezusatz
     */
    public function __construct($referenzierteNachrichtUUID = null, \StructType\Code_NachrichtAntwortCode $antwortrueckgabecode = null, $antwortrueckgabezusatz = null)
    {
        $this
            ->setReferenzierteNachrichtUUID($referenzierteNachrichtUUID)
            ->setAntwortrueckgabecode($antwortrueckgabecode)
            ->setAntwortrueckgabezusatz($antwortrueckgabezusatz);
    }
    /**
     * Get referenzierteNachrichtUUID value
     * @return string|null
     */
    public function getReferenzierteNachrichtUUID()
    {
        return $this->referenzierteNachrichtUUID;
    }
    /**
     * Set referenzierteNachrichtUUID value
     * @param string $referenzierteNachrichtUUID
     * @return \StructType\Transfer_rueckantwort_040501
     */
    public function setReferenzierteNachrichtUUID($referenzierteNachrichtUUID = null)
    {
        // validation for constraint: string
        if (!is_null($referenzierteNachrichtUUID) && !is_string($referenzierteNachrichtUUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenzierteNachrichtUUID, true), gettype($referenzierteNachrichtUUID)), __LINE__);
        }
        $this->referenzierteNachrichtUUID = $referenzierteNachrichtUUID;
        return $this;
    }
    /**
     * Get antwortrueckgabecode value
     * @return \StructType\Code_NachrichtAntwortCode|null
     */
    public function getAntwortrueckgabecode()
    {
        return $this->antwortrueckgabecode;
    }
    /**
     * Set antwortrueckgabecode value
     * @param \StructType\Code_NachrichtAntwortCode $antwortrueckgabecode
     * @return \StructType\Transfer_rueckantwort_040501
     */
    public function setAntwortrueckgabecode(\StructType\Code_NachrichtAntwortCode $antwortrueckgabecode = null)
    {
        $this->antwortrueckgabecode = $antwortrueckgabecode;
        return $this;
    }
    /**
     * Get antwortrueckgabezusatz value
     * @return string|null
     */
    public function getAntwortrueckgabezusatz()
    {
        return $this->antwortrueckgabezusatz;
    }
    /**
     * Set antwortrueckgabezusatz value
     * @param string $antwortrueckgabezusatz
     * @return \StructType\Transfer_rueckantwort_040501
     */
    public function setAntwortrueckgabezusatz($antwortrueckgabezusatz = null)
    {
        // validation for constraint: string
        if (!is_null($antwortrueckgabezusatz) && !is_string($antwortrueckgabezusatz)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($antwortrueckgabezusatz, true), gettype($antwortrueckgabezusatz)), __LINE__);
        }
        $this->antwortrueckgabezusatz = $antwortrueckgabezusatz;
        return $this;
    }
}
