<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for transfer.operation.040502 StructType
 * Meta information extracted from the WSDL
 * - documentation: Nachricht zur einfachen Übermittlungen von Datenobjekten aus dem XZuFi-Baukasten oder deren Löschung. Die Nachricht kann mit transfer.rueckantwort.xxx beantwortet werden.Bei der Übertragung soll sichergestellt sein, dass die Daten
 * redundanzfrei und konsistent übertragen werden. D.h. innerhalb eines Exports, sollen sich Daten nicht doppeln und zu jeder Referenz auch das referenzierte Objekt logisch aufschlüsselbar sein.
 * @subpackage Structs
 */
class Transfer_operation_040502 extends Basisnachricht
{
    /**
     * The transaktionID
     * Meta information extracted from the WSDL
     * - documentation: Angabe einer optionalen ID für eine Transaktion. Über diese können z.B. mehrere Nachrichten einen Import/Export-Vorgang zugeordnet werden.
     * - minOccurs: 0
     * @var string
     */
    public $transaktionID;
    /**
     * The transaktionPosition
     * Meta information extracted from the WSDL
     * - documentation: Position in der Reihenfolge aller Nachrichten in der aktuellen Transaktion.
     * - minOccurs: 0
     * @var int
     */
    public $transaktionPosition;
    /**
     * The loesche
     * @var \StructType\LoescheObjekt
     */
    public $loesche;
    /**
     * The schreibe
     * @var \StructType\SchreibeObjekt
     */
    public $schreibe;
    /**
     * Constructor method for transfer.operation.040502
     * @uses Transfer_operation_040502::setTransaktionID()
     * @uses Transfer_operation_040502::setTransaktionPosition()
     * @uses Transfer_operation_040502::setLoesche()
     * @uses Transfer_operation_040502::setSchreibe()
     * @param string $transaktionID
     * @param int $transaktionPosition
     * @param \StructType\LoescheObjekt $loesche
     * @param \StructType\SchreibeObjekt $schreibe
     */
    public function __construct($transaktionID = null, $transaktionPosition = null, \StructType\LoescheObjekt $loesche = null, \StructType\SchreibeObjekt $schreibe = null)
    {
        $this
            ->setTransaktionID($transaktionID)
            ->setTransaktionPosition($transaktionPosition)
            ->setLoesche($loesche)
            ->setSchreibe($schreibe);
    }
    /**
     * Get transaktionID value
     * @return string|null
     */
    public function getTransaktionID()
    {
        return $this->transaktionID;
    }
    /**
     * Set transaktionID value
     * @param string $transaktionID
     * @return \StructType\Transfer_operation_040502
     */
    public function setTransaktionID($transaktionID = null)
    {
        // validation for constraint: string
        if (!is_null($transaktionID) && !is_string($transaktionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transaktionID, true), gettype($transaktionID)), __LINE__);
        }
        $this->transaktionID = $transaktionID;
        return $this;
    }
    /**
     * Get transaktionPosition value
     * @return int|null
     */
    public function getTransaktionPosition()
    {
        return $this->transaktionPosition;
    }
    /**
     * Set transaktionPosition value
     * @param int $transaktionPosition
     * @return \StructType\Transfer_operation_040502
     */
    public function setTransaktionPosition($transaktionPosition = null)
    {
        // validation for constraint: int
        if (!is_null($transaktionPosition) && !(is_int($transaktionPosition) || ctype_digit($transaktionPosition))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transaktionPosition, true), gettype($transaktionPosition)), __LINE__);
        }
        $this->transaktionPosition = $transaktionPosition;
        return $this;
    }
    /**
     * Get loesche value
     * @return \StructType\LoescheObjekt|null
     */
    public function getLoesche()
    {
        return $this->loesche;
    }
    /**
     * Set loesche value
     * @param \StructType\LoescheObjekt $loesche
     * @return \StructType\Transfer_operation_040502
     */
    public function setLoesche(\StructType\LoescheObjekt $loesche = null)
    {
        $this->loesche = $loesche;
        return $this;
    }
    /**
     * Get schreibe value
     * @return \StructType\SchreibeObjekt|null
     */
    public function getSchreibe()
    {
        return $this->schreibe;
    }
    /**
     * Set schreibe value
     * @param \StructType\SchreibeObjekt $schreibe
     * @return \StructType\Transfer_operation_040502
     */
    public function setSchreibe(\StructType\SchreibeObjekt $schreibe = null)
    {
        $this->schreibe = $schreibe;
        return $this;
    }
}
