<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TopoCurvePropertyType StructType
 * @subpackage Structs
 */
class TopoCurvePropertyType extends AbstractStructBase
{
    /**
     * The TopoCurve
     * @var \StructType\TopoCurveType
     */
    public $TopoCurve;
    /**
     * The owns
     * @var bool
     */
    public $owns;
    /**
     * Constructor method for TopoCurvePropertyType
     * @uses TopoCurvePropertyType::setTopoCurve()
     * @uses TopoCurvePropertyType::setOwns()
     * @param \StructType\TopoCurveType $topoCurve
     * @param bool $owns
     */
    public function __construct(\StructType\TopoCurveType $topoCurve = null, $owns = null)
    {
        $this
            ->setTopoCurve($topoCurve)
            ->setOwns($owns);
    }
    /**
     * Get TopoCurve value
     * @return \StructType\TopoCurveType|null
     */
    public function getTopoCurve()
    {
        return $this->TopoCurve;
    }
    /**
     * Set TopoCurve value
     * @param \StructType\TopoCurveType $topoCurve
     * @return \StructType\TopoCurvePropertyType
     */
    public function setTopoCurve(\StructType\TopoCurveType $topoCurve = null)
    {
        $this->TopoCurve = $topoCurve;
        return $this;
    }
    /**
     * Get owns value
     * @return bool|null
     */
    public function getOwns()
    {
        return $this->owns;
    }
    /**
     * Set owns value
     * @param bool $owns
     * @return \StructType\TopoCurvePropertyType
     */
    public function setOwns($owns = null)
    {
        // validation for constraint: boolean
        if (!is_null($owns) && !is_bool($owns)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($owns, true), gettype($owns)), __LINE__);
        }
        $this->owns = $owns;
        return $this;
    }
}
