<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TimeNodeType StructType
 * @subpackage Structs
 */
class TimeNodeType extends AbstractStructBase
{
    /**
     * The previousEdge
     * @var \StructType\TimeEdgePropertyType
     */
    public $previousEdge;
    /**
     * The nextEdge
     * @var \StructType\TimeEdgePropertyType
     */
    public $nextEdge;
    /**
     * The position
     * @var \StructType\TimeInstantPropertyType
     */
    public $position;
    /**
     * Constructor method for TimeNodeType
     * @uses TimeNodeType::setPreviousEdge()
     * @uses TimeNodeType::setNextEdge()
     * @uses TimeNodeType::setPosition()
     * @param \StructType\TimeEdgePropertyType $previousEdge
     * @param \StructType\TimeEdgePropertyType $nextEdge
     * @param \StructType\TimeInstantPropertyType $position
     */
    public function __construct(\StructType\TimeEdgePropertyType $previousEdge = null, \StructType\TimeEdgePropertyType $nextEdge = null, \StructType\TimeInstantPropertyType $position = null)
    {
        $this
            ->setPreviousEdge($previousEdge)
            ->setNextEdge($nextEdge)
            ->setPosition($position);
    }
    /**
     * Get previousEdge value
     * @return \StructType\TimeEdgePropertyType|null
     */
    public function getPreviousEdge()
    {
        return $this->previousEdge;
    }
    /**
     * Set previousEdge value
     * @param \StructType\TimeEdgePropertyType $previousEdge
     * @return \StructType\TimeNodeType
     */
    public function setPreviousEdge(\StructType\TimeEdgePropertyType $previousEdge = null)
    {
        $this->previousEdge = $previousEdge;
        return $this;
    }
    /**
     * Get nextEdge value
     * @return \StructType\TimeEdgePropertyType|null
     */
    public function getNextEdge()
    {
        return $this->nextEdge;
    }
    /**
     * Set nextEdge value
     * @param \StructType\TimeEdgePropertyType $nextEdge
     * @return \StructType\TimeNodeType
     */
    public function setNextEdge(\StructType\TimeEdgePropertyType $nextEdge = null)
    {
        $this->nextEdge = $nextEdge;
        return $this;
    }
    /**
     * Get position value
     * @return \StructType\TimeInstantPropertyType|null
     */
    public function getPosition()
    {
        return $this->position;
    }
    /**
     * Set position value
     * @param \StructType\TimeInstantPropertyType $position
     * @return \StructType\TimeNodeType
     */
    public function setPosition(\StructType\TimeInstantPropertyType $position = null)
    {
        $this->position = $position;
        return $this;
    }
}
