<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TimeIntervalLengthType StructType
 * @subpackage Structs
 */
class TimeIntervalLengthType extends AbstractStructBase
{
    /**
     * The _
     * @var float
     */
    public $_;
    /**
     * The unit
     * @var string
     */
    public $unit;
    /**
     * The radix
     * @var int
     */
    public $radix;
    /**
     * The factor
     * @var int
     */
    public $factor;
    /**
     * Constructor method for TimeIntervalLengthType
     * @uses TimeIntervalLengthType::set_()
     * @uses TimeIntervalLengthType::setUnit()
     * @uses TimeIntervalLengthType::setRadix()
     * @uses TimeIntervalLengthType::setFactor()
     * @param float $_
     * @param string $unit
     * @param int $radix
     * @param int $factor
     */
    public function __construct($_ = null, $unit = null, $radix = null, $factor = null)
    {
        $this
            ->set_($_)
            ->setUnit($unit)
            ->setRadix($radix)
            ->setFactor($factor);
    }
    /**
     * Get _ value
     * @return float|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param float $_
     * @return \StructType\TimeIntervalLengthType
     */
    public function set_($_ = null)
    {
        // validation for constraint: float
        if (!is_null($_) && !(is_float($_) || is_numeric($_))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get unit value
     * @return string|null
     */
    public function getUnit()
    {
        return $this->unit;
    }
    /**
     * Set unit value
     * @param string $unit
     * @return \StructType\TimeIntervalLengthType
     */
    public function setUnit($unit = null)
    {
        // validation for constraint: string
        if (!is_null($unit) && !is_string($unit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unit, true), gettype($unit)), __LINE__);
        }
        $this->unit = $unit;
        return $this;
    }
    /**
     * Get radix value
     * @return int|null
     */
    public function getRadix()
    {
        return $this->radix;
    }
    /**
     * Set radix value
     * @param int $radix
     * @return \StructType\TimeIntervalLengthType
     */
    public function setRadix($radix = null)
    {
        // validation for constraint: int
        if (!is_null($radix) && !(is_int($radix) || ctype_digit($radix))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($radix, true), gettype($radix)), __LINE__);
        }
        $this->radix = $radix;
        return $this;
    }
    /**
     * Get factor value
     * @return int|null
     */
    public function getFactor()
    {
        return $this->factor;
    }
    /**
     * Set factor value
     * @param int $factor
     * @return \StructType\TimeIntervalLengthType
     */
    public function setFactor($factor = null)
    {
        // validation for constraint: int
        if (!is_null($factor) && !(is_int($factor) || ctype_digit($factor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($factor, true), gettype($factor)), __LINE__);
        }
        $this->factor = $factor;
        return $this;
    }
}
