<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TimeCoordinateSystemType StructType
 * @subpackage Structs
 */
class TimeCoordinateSystemType extends AbstractStructBase
{
    /**
     * The originPosition
     * @var \StructType\TimePositionType
     */
    public $originPosition;
    /**
     * The origin
     * @var \StructType\TimeInstantPropertyType
     */
    public $origin;
    /**
     * The interval
     * @var \StructType\TimeIntervalLengthType
     */
    public $interval;
    /**
     * Constructor method for TimeCoordinateSystemType
     * @uses TimeCoordinateSystemType::setOriginPosition()
     * @uses TimeCoordinateSystemType::setOrigin()
     * @uses TimeCoordinateSystemType::setInterval()
     * @param \StructType\TimePositionType $originPosition
     * @param \StructType\TimeInstantPropertyType $origin
     * @param \StructType\TimeIntervalLengthType $interval
     */
    public function __construct(\StructType\TimePositionType $originPosition = null, \StructType\TimeInstantPropertyType $origin = null, \StructType\TimeIntervalLengthType $interval = null)
    {
        $this
            ->setOriginPosition($originPosition)
            ->setOrigin($origin)
            ->setInterval($interval);
    }
    /**
     * Get originPosition value
     * @return \StructType\TimePositionType|null
     */
    public function getOriginPosition()
    {
        return $this->originPosition;
    }
    /**
     * Set originPosition value
     * @param \StructType\TimePositionType $originPosition
     * @return \StructType\TimeCoordinateSystemType
     */
    public function setOriginPosition(\StructType\TimePositionType $originPosition = null)
    {
        $this->originPosition = $originPosition;
        return $this;
    }
    /**
     * Get origin value
     * @return \StructType\TimeInstantPropertyType|null
     */
    public function getOrigin()
    {
        return $this->origin;
    }
    /**
     * Set origin value
     * @param \StructType\TimeInstantPropertyType $origin
     * @return \StructType\TimeCoordinateSystemType
     */
    public function setOrigin(\StructType\TimeInstantPropertyType $origin = null)
    {
        $this->origin = $origin;
        return $this;
    }
    /**
     * Get interval value
     * @return \StructType\TimeIntervalLengthType|null
     */
    public function getInterval()
    {
        return $this->interval;
    }
    /**
     * Set interval value
     * @param \StructType\TimeIntervalLengthType $interval
     * @return \StructType\TimeCoordinateSystemType
     */
    public function setInterval(\StructType\TimeIntervalLengthType $interval = null)
    {
        $this->interval = $interval;
        return $this;
    }
}
