<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SuchprofilOrganisationseinheit StructType
 * Meta information extracted from the WSDL
 * - documentation: Suchprofil für Organisationseinheiten.
 * @subpackage Structs
 */
class SuchprofilOrganisationseinheit extends Suchprofil
{
    /**
     * The organisationseinheitskategorie
     * Meta information extracted from the WSDL
     * - documentation: Angabe von Kategorien von Organisationseinheiten auf welche das Suchergebnis eingeschränkt werden soll.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SuchparameterKategorie[]
     */
    public $organisationseinheitskategorie;
    /**
     * The uebergeordneteOrganisationseinheitID
     * Meta information extracted from the WSDL
     * - documentation: Einschränkung auf Kindelemente von angegebener Organisationseinheit.
     * - minOccurs: 0
     * @var \StructType\Identifikator
     */
    public $uebergeordneteOrganisationseinheitID;
    /**
     * The standortSuchbegriff
     * Meta information extracted from the WSDL
     * - documentation: Suchbegriff für Ort in Anschriften. Es wird in Ort und PLZ gesucht.
     * - minOccurs: 0
     * @var string
     */
    public $standortSuchbegriff;
    /**
     * The standortGebietID
     * Meta information extracted from the WSDL
     * - documentation: Angabe von Gebieten in Adressen (Standortsuche).
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Identifikator[]
     */
    public $standortGebietID;
    /**
     * The zustaendigkeitLeistungID
     * Meta information extracted from the WSDL
     * - documentation: Angabe von Leistungen, für welche die OE zuständig sein soll. In Kombination mit zustaendigkeitGebietID. Hierdurch kann eine Suche nach zuständigen Stellen realisiert werden. Die Angabe von zustaendigkeitGebietID und
     * zustaendigkeitLeistungID wird logisch UND verknüpft, d.h. die OE muss für alle Leistungen für alle Gebiete zuständig sein.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Identifikator[]
     */
    public $zustaendigkeitLeistungID;
    /**
     * The zustaendigkeitGebietID
     * Meta information extracted from the WSDL
     * - documentation: Angabe von Gebieten, für welche die OE zuständig sein soll. In Kombination mit zustaendigkeitLeistungID. Achtung: Es muss hier unbedingt die geografische Zuständigkeit beachtet werden. Beispiel: Wird hier das Gebiet
     * "Sachsen-Anhalt" angegeben, dürfen auch nur OEs, welche für ganz Sachsen-Anhalt zuständig sind, ausgegeben werden. Zum Beispiel Ministerien, Landesverwaltungsamt etc. Wird eine konkrete Gemeinde angegeben, muss das System den Gebietsbaum bis zur
     * Wurzel durchsuchen, da auch Zuständigkeiten für den Landkreis, Regierungsbezirk, Bundesland oder Deutschland zum Tragen kommen können.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Identifikator[]
     */
    public $zustaendigkeitGebietID;
    /**
     * The kennzeichenErweiterteAusgabe
     * Meta information extracted from the WSDL
     * - documentation: Kennzeichen, ob im Ergebnis Organisationseinheit oder OrganisationseinheitErweitert zurückgeben werden soll. Letztere enthält alle Zuständigkeiten, Formulare und Kontaktpersonen.
     * - default: false
     * @var bool
     */
    public $kennzeichenErweiterteAusgabe;
    /**
     * The kennzeichenNurBasisinformation
     * Meta information extracted from the WSDL
     * - documentation: Kennzeichen, ob nur Basisinformationen zurückgegeben werden soll. In NachrichtenAntworten wird dann anstatt des eigentlichen Objekts das BasisinformationObjekt zurückgegeben.
     * - default: false
     * @var bool
     */
    public $kennzeichenNurBasisinformation;
    /**
     * Constructor method for SuchprofilOrganisationseinheit
     * @uses SuchprofilOrganisationseinheit::setOrganisationseinheitskategorie()
     * @uses SuchprofilOrganisationseinheit::setUebergeordneteOrganisationseinheitID()
     * @uses SuchprofilOrganisationseinheit::setStandortSuchbegriff()
     * @uses SuchprofilOrganisationseinheit::setStandortGebietID()
     * @uses SuchprofilOrganisationseinheit::setZustaendigkeitLeistungID()
     * @uses SuchprofilOrganisationseinheit::setZustaendigkeitGebietID()
     * @uses SuchprofilOrganisationseinheit::setKennzeichenErweiterteAusgabe()
     * @uses SuchprofilOrganisationseinheit::setKennzeichenNurBasisinformation()
     * @param \StructType\SuchparameterKategorie[] $organisationseinheitskategorie
     * @param \StructType\Identifikator $uebergeordneteOrganisationseinheitID
     * @param string $standortSuchbegriff
     * @param \StructType\Identifikator[] $standortGebietID
     * @param \StructType\Identifikator[] $zustaendigkeitLeistungID
     * @param \StructType\Identifikator[] $zustaendigkeitGebietID
     * @param bool $kennzeichenErweiterteAusgabe
     * @param bool $kennzeichenNurBasisinformation
     */
    public function __construct(array $organisationseinheitskategorie = array(), \StructType\Identifikator $uebergeordneteOrganisationseinheitID = null, $standortSuchbegriff = null, array $standortGebietID = array(), array $zustaendigkeitLeistungID = array(), array $zustaendigkeitGebietID = array(), $kennzeichenErweiterteAusgabe = false, $kennzeichenNurBasisinformation = false)
    {
        $this
            ->setOrganisationseinheitskategorie($organisationseinheitskategorie)
            ->setUebergeordneteOrganisationseinheitID($uebergeordneteOrganisationseinheitID)
            ->setStandortSuchbegriff($standortSuchbegriff)
            ->setStandortGebietID($standortGebietID)
            ->setZustaendigkeitLeistungID($zustaendigkeitLeistungID)
            ->setZustaendigkeitGebietID($zustaendigkeitGebietID)
            ->setKennzeichenErweiterteAusgabe($kennzeichenErweiterteAusgabe)
            ->setKennzeichenNurBasisinformation($kennzeichenNurBasisinformation);
    }
    /**
     * Get organisationseinheitskategorie value
     * @return \StructType\SuchparameterKategorie[]|null
     */
    public function getOrganisationseinheitskategorie()
    {
        return $this->organisationseinheitskategorie;
    }
    /**
     * This method is responsible for validating the values passed to the setOrganisationseinheitskategorie method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrganisationseinheitskategorie method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrganisationseinheitskategorieForArrayConstraintsFromSetOrganisationseinheitskategorie(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $suchprofilOrganisationseinheitOrganisationseinheitskategorieItem) {
            // validation for constraint: itemType
            if (!$suchprofilOrganisationseinheitOrganisationseinheitskategorieItem instanceof \StructType\SuchparameterKategorie) {
                $invalidValues[] = is_object($suchprofilOrganisationseinheitOrganisationseinheitskategorieItem) ? get_class($suchprofilOrganisationseinheitOrganisationseinheitskategorieItem) : sprintf('%s(%s)', gettype($suchprofilOrganisationseinheitOrganisationseinheitskategorieItem), var_export($suchprofilOrganisationseinheitOrganisationseinheitskategorieItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The organisationseinheitskategorie property can only contain items of type \StructType\SuchparameterKategorie, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set organisationseinheitskategorie value
     * @throws \InvalidArgumentException
     * @param \StructType\SuchparameterKategorie[] $organisationseinheitskategorie
     * @return \StructType\SuchprofilOrganisationseinheit
     */
    public function setOrganisationseinheitskategorie(array $organisationseinheitskategorie = array())
    {
        // validation for constraint: array
        if ('' !== ($organisationseinheitskategorieArrayErrorMessage = self::validateOrganisationseinheitskategorieForArrayConstraintsFromSetOrganisationseinheitskategorie($organisationseinheitskategorie))) {
            throw new \InvalidArgumentException($organisationseinheitskategorieArrayErrorMessage, __LINE__);
        }
        $this->organisationseinheitskategorie = $organisationseinheitskategorie;
        return $this;
    }
    /**
     * Add item to organisationseinheitskategorie value
     * @throws \InvalidArgumentException
     * @param \StructType\SuchparameterKategorie $item
     * @return \StructType\SuchprofilOrganisationseinheit
     */
    public function addToOrganisationseinheitskategorie(\StructType\SuchparameterKategorie $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SuchparameterKategorie) {
            throw new \InvalidArgumentException(sprintf('The organisationseinheitskategorie property can only contain items of type \StructType\SuchparameterKategorie, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->organisationseinheitskategorie[] = $item;
        return $this;
    }
    /**
     * Get uebergeordneteOrganisationseinheitID value
     * @return \StructType\Identifikator|null
     */
    public function getUebergeordneteOrganisationseinheitID()
    {
        return $this->uebergeordneteOrganisationseinheitID;
    }
    /**
     * Set uebergeordneteOrganisationseinheitID value
     * @param \StructType\Identifikator $uebergeordneteOrganisationseinheitID
     * @return \StructType\SuchprofilOrganisationseinheit
     */
    public function setUebergeordneteOrganisationseinheitID(\StructType\Identifikator $uebergeordneteOrganisationseinheitID = null)
    {
        $this->uebergeordneteOrganisationseinheitID = $uebergeordneteOrganisationseinheitID;
        return $this;
    }
    /**
     * Get standortSuchbegriff value
     * @return string|null
     */
    public function getStandortSuchbegriff()
    {
        return $this->standortSuchbegriff;
    }
    /**
     * Set standortSuchbegriff value
     * @param string $standortSuchbegriff
     * @return \StructType\SuchprofilOrganisationseinheit
     */
    public function setStandortSuchbegriff($standortSuchbegriff = null)
    {
        // validation for constraint: string
        if (!is_null($standortSuchbegriff) && !is_string($standortSuchbegriff)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($standortSuchbegriff, true), gettype($standortSuchbegriff)), __LINE__);
        }
        $this->standortSuchbegriff = $standortSuchbegriff;
        return $this;
    }
    /**
     * Get standortGebietID value
     * @return \StructType\Identifikator[]|null
     */
    public function getStandortGebietID()
    {
        return $this->standortGebietID;
    }
    /**
     * This method is responsible for validating the values passed to the setStandortGebietID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStandortGebietID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStandortGebietIDForArrayConstraintsFromSetStandortGebietID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $suchprofilOrganisationseinheitStandortGebietIDItem) {
            // validation for constraint: itemType
            if (!$suchprofilOrganisationseinheitStandortGebietIDItem instanceof \StructType\Identifikator) {
                $invalidValues[] = is_object($suchprofilOrganisationseinheitStandortGebietIDItem) ? get_class($suchprofilOrganisationseinheitStandortGebietIDItem) : sprintf('%s(%s)', gettype($suchprofilOrganisationseinheitStandortGebietIDItem), var_export($suchprofilOrganisationseinheitStandortGebietIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The standortGebietID property can only contain items of type \StructType\Identifikator, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set standortGebietID value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator[] $standortGebietID
     * @return \StructType\SuchprofilOrganisationseinheit
     */
    public function setStandortGebietID(array $standortGebietID = array())
    {
        // validation for constraint: array
        if ('' !== ($standortGebietIDArrayErrorMessage = self::validateStandortGebietIDForArrayConstraintsFromSetStandortGebietID($standortGebietID))) {
            throw new \InvalidArgumentException($standortGebietIDArrayErrorMessage, __LINE__);
        }
        $this->standortGebietID = $standortGebietID;
        return $this;
    }
    /**
     * Add item to standortGebietID value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator $item
     * @return \StructType\SuchprofilOrganisationseinheit
     */
    public function addToStandortGebietID(\StructType\Identifikator $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Identifikator) {
            throw new \InvalidArgumentException(sprintf('The standortGebietID property can only contain items of type \StructType\Identifikator, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->standortGebietID[] = $item;
        return $this;
    }
    /**
     * Get zustaendigkeitLeistungID value
     * @return \StructType\Identifikator[]|null
     */
    public function getZustaendigkeitLeistungID()
    {
        return $this->zustaendigkeitLeistungID;
    }
    /**
     * This method is responsible for validating the values passed to the setZustaendigkeitLeistungID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setZustaendigkeitLeistungID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateZustaendigkeitLeistungIDForArrayConstraintsFromSetZustaendigkeitLeistungID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $suchprofilOrganisationseinheitZustaendigkeitLeistungIDItem) {
            // validation for constraint: itemType
            if (!$suchprofilOrganisationseinheitZustaendigkeitLeistungIDItem instanceof \StructType\Identifikator) {
                $invalidValues[] = is_object($suchprofilOrganisationseinheitZustaendigkeitLeistungIDItem) ? get_class($suchprofilOrganisationseinheitZustaendigkeitLeistungIDItem) : sprintf('%s(%s)', gettype($suchprofilOrganisationseinheitZustaendigkeitLeistungIDItem), var_export($suchprofilOrganisationseinheitZustaendigkeitLeistungIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The zustaendigkeitLeistungID property can only contain items of type \StructType\Identifikator, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set zustaendigkeitLeistungID value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator[] $zustaendigkeitLeistungID
     * @return \StructType\SuchprofilOrganisationseinheit
     */
    public function setZustaendigkeitLeistungID(array $zustaendigkeitLeistungID = array())
    {
        // validation for constraint: array
        if ('' !== ($zustaendigkeitLeistungIDArrayErrorMessage = self::validateZustaendigkeitLeistungIDForArrayConstraintsFromSetZustaendigkeitLeistungID($zustaendigkeitLeistungID))) {
            throw new \InvalidArgumentException($zustaendigkeitLeistungIDArrayErrorMessage, __LINE__);
        }
        $this->zustaendigkeitLeistungID = $zustaendigkeitLeistungID;
        return $this;
    }
    /**
     * Add item to zustaendigkeitLeistungID value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator $item
     * @return \StructType\SuchprofilOrganisationseinheit
     */
    public function addToZustaendigkeitLeistungID(\StructType\Identifikator $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Identifikator) {
            throw new \InvalidArgumentException(sprintf('The zustaendigkeitLeistungID property can only contain items of type \StructType\Identifikator, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->zustaendigkeitLeistungID[] = $item;
        return $this;
    }
    /**
     * Get zustaendigkeitGebietID value
     * @return \StructType\Identifikator[]|null
     */
    public function getZustaendigkeitGebietID()
    {
        return $this->zustaendigkeitGebietID;
    }
    /**
     * This method is responsible for validating the values passed to the setZustaendigkeitGebietID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setZustaendigkeitGebietID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateZustaendigkeitGebietIDForArrayConstraintsFromSetZustaendigkeitGebietID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $suchprofilOrganisationseinheitZustaendigkeitGebietIDItem) {
            // validation for constraint: itemType
            if (!$suchprofilOrganisationseinheitZustaendigkeitGebietIDItem instanceof \StructType\Identifikator) {
                $invalidValues[] = is_object($suchprofilOrganisationseinheitZustaendigkeitGebietIDItem) ? get_class($suchprofilOrganisationseinheitZustaendigkeitGebietIDItem) : sprintf('%s(%s)', gettype($suchprofilOrganisationseinheitZustaendigkeitGebietIDItem), var_export($suchprofilOrganisationseinheitZustaendigkeitGebietIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The zustaendigkeitGebietID property can only contain items of type \StructType\Identifikator, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set zustaendigkeitGebietID value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator[] $zustaendigkeitGebietID
     * @return \StructType\SuchprofilOrganisationseinheit
     */
    public function setZustaendigkeitGebietID(array $zustaendigkeitGebietID = array())
    {
        // validation for constraint: array
        if ('' !== ($zustaendigkeitGebietIDArrayErrorMessage = self::validateZustaendigkeitGebietIDForArrayConstraintsFromSetZustaendigkeitGebietID($zustaendigkeitGebietID))) {
            throw new \InvalidArgumentException($zustaendigkeitGebietIDArrayErrorMessage, __LINE__);
        }
        $this->zustaendigkeitGebietID = $zustaendigkeitGebietID;
        return $this;
    }
    /**
     * Add item to zustaendigkeitGebietID value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator $item
     * @return \StructType\SuchprofilOrganisationseinheit
     */
    public function addToZustaendigkeitGebietID(\StructType\Identifikator $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Identifikator) {
            throw new \InvalidArgumentException(sprintf('The zustaendigkeitGebietID property can only contain items of type \StructType\Identifikator, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->zustaendigkeitGebietID[] = $item;
        return $this;
    }
    /**
     * Get kennzeichenErweiterteAusgabe value
     * @return bool|null
     */
    public function getKennzeichenErweiterteAusgabe()
    {
        return $this->kennzeichenErweiterteAusgabe;
    }
    /**
     * Set kennzeichenErweiterteAusgabe value
     * @param bool $kennzeichenErweiterteAusgabe
     * @return \StructType\SuchprofilOrganisationseinheit
     */
    public function setKennzeichenErweiterteAusgabe($kennzeichenErweiterteAusgabe = false)
    {
        // validation for constraint: boolean
        if (!is_null($kennzeichenErweiterteAusgabe) && !is_bool($kennzeichenErweiterteAusgabe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($kennzeichenErweiterteAusgabe, true), gettype($kennzeichenErweiterteAusgabe)), __LINE__);
        }
        $this->kennzeichenErweiterteAusgabe = $kennzeichenErweiterteAusgabe;
        return $this;
    }
    /**
     * Get kennzeichenNurBasisinformation value
     * @return bool|null
     */
    public function getKennzeichenNurBasisinformation()
    {
        return $this->kennzeichenNurBasisinformation;
    }
    /**
     * Set kennzeichenNurBasisinformation value
     * @param bool $kennzeichenNurBasisinformation
     * @return \StructType\SuchprofilOrganisationseinheit
     */
    public function setKennzeichenNurBasisinformation($kennzeichenNurBasisinformation = false)
    {
        // validation for constraint: boolean
        if (!is_null($kennzeichenNurBasisinformation) && !is_bool($kennzeichenNurBasisinformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($kennzeichenNurBasisinformation, true), gettype($kennzeichenNurBasisinformation)), __LINE__);
        }
        $this->kennzeichenNurBasisinformation = $kennzeichenNurBasisinformation;
        return $this;
    }
}
