<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SuchprofilGebiet StructType
 * Meta information extracted from the WSDL
 * - documentation: Suchprofil für Gebiete.
 * @subpackage Structs
 */
class SuchprofilGebiet extends Suchprofil
{
    /**
     * The gebietstyp
     * Meta information extracted from the WSDL
     * - documentation: Einschränkung auf bestimmte Gebietstypen. Diese werden ODER verknüpft.Es wird der Datentyp SuchparameterKategorie verwendet. In diesem Kontext ist ein Gebietstyp einer Kategorie gleichzusetzen.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SuchparameterKategorie[]
     */
    public $gebietstyp;
    /**
     * The uebergeordneteGebietID
     * Meta information extracted from the WSDL
     * - documentation: Gebiet ID, von denen die Kinder zurückgegeben werden sollen.
     * - minOccurs: 0
     * @var \StructType\Identifikator
     */
    public $uebergeordneteGebietID;
    /**
     * The kennzeichenNurBasisinformation
     * Meta information extracted from the WSDL
     * - documentation: Kennzeichen, ob nur Basisinformationen zurückgegeben werden soll. In NachrichtenAntworten wird dann anstatt des eigentlichen Objekts das BasisinformationObjekt zurückgegeben.
     * - default: false
     * @var bool
     */
    public $kennzeichenNurBasisinformation;
    /**
     * Constructor method for SuchprofilGebiet
     * @uses SuchprofilGebiet::setGebietstyp()
     * @uses SuchprofilGebiet::setUebergeordneteGebietID()
     * @uses SuchprofilGebiet::setKennzeichenNurBasisinformation()
     * @param \StructType\SuchparameterKategorie[] $gebietstyp
     * @param \StructType\Identifikator $uebergeordneteGebietID
     * @param bool $kennzeichenNurBasisinformation
     */
    public function __construct(array $gebietstyp = array(), \StructType\Identifikator $uebergeordneteGebietID = null, $kennzeichenNurBasisinformation = false)
    {
        $this
            ->setGebietstyp($gebietstyp)
            ->setUebergeordneteGebietID($uebergeordneteGebietID)
            ->setKennzeichenNurBasisinformation($kennzeichenNurBasisinformation);
    }
    /**
     * Get gebietstyp value
     * @return \StructType\SuchparameterKategorie[]|null
     */
    public function getGebietstyp()
    {
        return $this->gebietstyp;
    }
    /**
     * This method is responsible for validating the values passed to the setGebietstyp method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGebietstyp method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGebietstypForArrayConstraintsFromSetGebietstyp(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $suchprofilGebietGebietstypItem) {
            // validation for constraint: itemType
            if (!$suchprofilGebietGebietstypItem instanceof \StructType\SuchparameterKategorie) {
                $invalidValues[] = is_object($suchprofilGebietGebietstypItem) ? get_class($suchprofilGebietGebietstypItem) : sprintf('%s(%s)', gettype($suchprofilGebietGebietstypItem), var_export($suchprofilGebietGebietstypItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The gebietstyp property can only contain items of type \StructType\SuchparameterKategorie, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set gebietstyp value
     * @throws \InvalidArgumentException
     * @param \StructType\SuchparameterKategorie[] $gebietstyp
     * @return \StructType\SuchprofilGebiet
     */
    public function setGebietstyp(array $gebietstyp = array())
    {
        // validation for constraint: array
        if ('' !== ($gebietstypArrayErrorMessage = self::validateGebietstypForArrayConstraintsFromSetGebietstyp($gebietstyp))) {
            throw new \InvalidArgumentException($gebietstypArrayErrorMessage, __LINE__);
        }
        $this->gebietstyp = $gebietstyp;
        return $this;
    }
    /**
     * Add item to gebietstyp value
     * @throws \InvalidArgumentException
     * @param \StructType\SuchparameterKategorie $item
     * @return \StructType\SuchprofilGebiet
     */
    public function addToGebietstyp(\StructType\SuchparameterKategorie $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SuchparameterKategorie) {
            throw new \InvalidArgumentException(sprintf('The gebietstyp property can only contain items of type \StructType\SuchparameterKategorie, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->gebietstyp[] = $item;
        return $this;
    }
    /**
     * Get uebergeordneteGebietID value
     * @return \StructType\Identifikator|null
     */
    public function getUebergeordneteGebietID()
    {
        return $this->uebergeordneteGebietID;
    }
    /**
     * Set uebergeordneteGebietID value
     * @param \StructType\Identifikator $uebergeordneteGebietID
     * @return \StructType\SuchprofilGebiet
     */
    public function setUebergeordneteGebietID(\StructType\Identifikator $uebergeordneteGebietID = null)
    {
        $this->uebergeordneteGebietID = $uebergeordneteGebietID;
        return $this;
    }
    /**
     * Get kennzeichenNurBasisinformation value
     * @return bool|null
     */
    public function getKennzeichenNurBasisinformation()
    {
        return $this->kennzeichenNurBasisinformation;
    }
    /**
     * Set kennzeichenNurBasisinformation value
     * @param bool $kennzeichenNurBasisinformation
     * @return \StructType\SuchprofilGebiet
     */
    public function setKennzeichenNurBasisinformation($kennzeichenNurBasisinformation = false)
    {
        // validation for constraint: boolean
        if (!is_null($kennzeichenNurBasisinformation) && !is_bool($kennzeichenNurBasisinformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($kennzeichenNurBasisinformation, true), gettype($kennzeichenNurBasisinformation)), __LINE__);
        }
        $this->kennzeichenNurBasisinformation = $kennzeichenNurBasisinformation;
        return $this;
    }
}
