<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Suchprofil StructType
 * Meta information extracted from the WSDL
 * - documentation: Suchprofil ist der allgemeine Datentyp für Suchparameter für Anfragenachrichten. Alle Parameter werden logisch UND verknüpft.
 * @subpackage Structs
 */
class Suchprofil extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - documentation: Angabe von IDs. Es wird in den primären und (wenn vorhanden) in sekundären IDs gesucht. Angegebene IDs werden hier "ODER" verknüpft.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Identifikator[]
     */
    public $id;
    /**
     * The suchbegriff
     * Meta information extracted from the WSDL
     * - documentation: Suchbegriff wird in Bezeichnungen, Kurzbezeichnungen gesucht.
     * - minOccurs: 0
     * @var \StructType\String_Localized
     */
    public $suchbegriff;
    /**
     * The kennzeichenVolltext
     * Meta information extracted from the WSDL
     * - documentation: Suchbegriff wird zusätzlich in Beschreibungen, Kurzbeschreibungen oder auch Synonymen gesucht.
     * - minOccurs: 0
     * @var bool
     */
    public $kennzeichenVolltext;
    /**
     * The herausgeberID
     * Meta information extracted from the WSDL
     * - documentation: IDs von Herausgebern nach denen das Ergebnis gefiltert wird. Hier könnte z.B. eine 115-Teilnehmernummer angegeben werden.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Identifikator[]
     */
    public $herausgeberID;
    /**
     * The gueltigkeitszeitraum
     * Meta information extracted from the WSDL
     * - documentation: Parameter zur Steuerung der Gültigkeitszeiträume der Suchergebnisse.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Zeitraum[]
     */
    public $gueltigkeitszeitraum;
    /**
     * The aenderungszeitraum
     * Meta information extracted from the WSDL
     * - documentation: Angabe eines Zeitraums nach dem Änderungsdatum von Objekten. Es werden dann nur die Ergebnisse geliefert, welche im angegebenen Zeitraum geändert wurden.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Zeitraum[]
     */
    public $aenderungszeitraum;
    /**
     * The verfuegbareSprache
     * Meta information extracted from the WSDL
     * - documentation: Zur Eingrenzung des Suchergebnisses auf die Objekte, welche in den hier angegebenen Sprachversionen vorliegen. Die Suche soll untergeordnete Sprachcodes berücksichtigen. Zum Beispiel soll die Suche nach "de" auch Objekte mit den
     * Sprachversionen "de-DE" und "de-AT" finden.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $verfuegbareSprache;
    /**
     * The elementfilterSprache
     * Meta information extracted from the WSDL
     * - documentation: Werden hier Sprachcodes angegeben, dann werden alle String.Localized Elemente ausschließlich in diesen Sprachen ausgegeben. Alle anderen nicht. Die Suche soll untergeordnete Sprachcodes berücksichtigen. Zum Beispiel soll der Filter
     * "de" auch Elemente mit den Sprachversionen "de-DE" und "de-AT" zulassen.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $elementfilterSprache;
    /**
     * Constructor method for Suchprofil
     * @uses Suchprofil::setId()
     * @uses Suchprofil::setSuchbegriff()
     * @uses Suchprofil::setKennzeichenVolltext()
     * @uses Suchprofil::setHerausgeberID()
     * @uses Suchprofil::setGueltigkeitszeitraum()
     * @uses Suchprofil::setAenderungszeitraum()
     * @uses Suchprofil::setVerfuegbareSprache()
     * @uses Suchprofil::setElementfilterSprache()
     * @param \StructType\Identifikator[] $id
     * @param \StructType\String_Localized $suchbegriff
     * @param bool $kennzeichenVolltext
     * @param \StructType\Identifikator[] $herausgeberID
     * @param \StructType\Zeitraum[] $gueltigkeitszeitraum
     * @param \StructType\Zeitraum[] $aenderungszeitraum
     * @param string[] $verfuegbareSprache
     * @param string[] $elementfilterSprache
     */
    public function __construct(array $id = array(), \StructType\String_Localized $suchbegriff = null, $kennzeichenVolltext = null, array $herausgeberID = array(), array $gueltigkeitszeitraum = array(), array $aenderungszeitraum = array(), array $verfuegbareSprache = array(), array $elementfilterSprache = array())
    {
        $this
            ->setId($id)
            ->setSuchbegriff($suchbegriff)
            ->setKennzeichenVolltext($kennzeichenVolltext)
            ->setHerausgeberID($herausgeberID)
            ->setGueltigkeitszeitraum($gueltigkeitszeitraum)
            ->setAenderungszeitraum($aenderungszeitraum)
            ->setVerfuegbareSprache($verfuegbareSprache)
            ->setElementfilterSprache($elementfilterSprache);
    }
    /**
     * Get id value
     * @return \StructType\Identifikator[]|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * This method is responsible for validating the values passed to the setId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIdForArrayConstraintsFromSetId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $suchprofilIdItem) {
            // validation for constraint: itemType
            if (!$suchprofilIdItem instanceof \StructType\Identifikator) {
                $invalidValues[] = is_object($suchprofilIdItem) ? get_class($suchprofilIdItem) : sprintf('%s(%s)', gettype($suchprofilIdItem), var_export($suchprofilIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The id property can only contain items of type \StructType\Identifikator, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set id value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator[] $id
     * @return \StructType\Suchprofil
     */
    public function setId(array $id = array())
    {
        // validation for constraint: array
        if ('' !== ($idArrayErrorMessage = self::validateIdForArrayConstraintsFromSetId($id))) {
            throw new \InvalidArgumentException($idArrayErrorMessage, __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Add item to id value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator $item
     * @return \StructType\Suchprofil
     */
    public function addToId(\StructType\Identifikator $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Identifikator) {
            throw new \InvalidArgumentException(sprintf('The id property can only contain items of type \StructType\Identifikator, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->id[] = $item;
        return $this;
    }
    /**
     * Get suchbegriff value
     * @return \StructType\String_Localized|null
     */
    public function getSuchbegriff()
    {
        return $this->suchbegriff;
    }
    /**
     * Set suchbegriff value
     * @param \StructType\String_Localized $suchbegriff
     * @return \StructType\Suchprofil
     */
    public function setSuchbegriff(\StructType\String_Localized $suchbegriff = null)
    {
        $this->suchbegriff = $suchbegriff;
        return $this;
    }
    /**
     * Get kennzeichenVolltext value
     * @return bool|null
     */
    public function getKennzeichenVolltext()
    {
        return $this->kennzeichenVolltext;
    }
    /**
     * Set kennzeichenVolltext value
     * @param bool $kennzeichenVolltext
     * @return \StructType\Suchprofil
     */
    public function setKennzeichenVolltext($kennzeichenVolltext = null)
    {
        // validation for constraint: boolean
        if (!is_null($kennzeichenVolltext) && !is_bool($kennzeichenVolltext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($kennzeichenVolltext, true), gettype($kennzeichenVolltext)), __LINE__);
        }
        $this->kennzeichenVolltext = $kennzeichenVolltext;
        return $this;
    }
    /**
     * Get herausgeberID value
     * @return \StructType\Identifikator[]|null
     */
    public function getHerausgeberID()
    {
        return $this->herausgeberID;
    }
    /**
     * This method is responsible for validating the values passed to the setHerausgeberID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHerausgeberID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHerausgeberIDForArrayConstraintsFromSetHerausgeberID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $suchprofilHerausgeberIDItem) {
            // validation for constraint: itemType
            if (!$suchprofilHerausgeberIDItem instanceof \StructType\Identifikator) {
                $invalidValues[] = is_object($suchprofilHerausgeberIDItem) ? get_class($suchprofilHerausgeberIDItem) : sprintf('%s(%s)', gettype($suchprofilHerausgeberIDItem), var_export($suchprofilHerausgeberIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The herausgeberID property can only contain items of type \StructType\Identifikator, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set herausgeberID value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator[] $herausgeberID
     * @return \StructType\Suchprofil
     */
    public function setHerausgeberID(array $herausgeberID = array())
    {
        // validation for constraint: array
        if ('' !== ($herausgeberIDArrayErrorMessage = self::validateHerausgeberIDForArrayConstraintsFromSetHerausgeberID($herausgeberID))) {
            throw new \InvalidArgumentException($herausgeberIDArrayErrorMessage, __LINE__);
        }
        $this->herausgeberID = $herausgeberID;
        return $this;
    }
    /**
     * Add item to herausgeberID value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator $item
     * @return \StructType\Suchprofil
     */
    public function addToHerausgeberID(\StructType\Identifikator $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Identifikator) {
            throw new \InvalidArgumentException(sprintf('The herausgeberID property can only contain items of type \StructType\Identifikator, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->herausgeberID[] = $item;
        return $this;
    }
    /**
     * Get gueltigkeitszeitraum value
     * @return \StructType\Zeitraum[]|null
     */
    public function getGueltigkeitszeitraum()
    {
        return $this->gueltigkeitszeitraum;
    }
    /**
     * This method is responsible for validating the values passed to the setGueltigkeitszeitraum method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGueltigkeitszeitraum method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGueltigkeitszeitraumForArrayConstraintsFromSetGueltigkeitszeitraum(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $suchprofilGueltigkeitszeitraumItem) {
            // validation for constraint: itemType
            if (!$suchprofilGueltigkeitszeitraumItem instanceof \StructType\Zeitraum) {
                $invalidValues[] = is_object($suchprofilGueltigkeitszeitraumItem) ? get_class($suchprofilGueltigkeitszeitraumItem) : sprintf('%s(%s)', gettype($suchprofilGueltigkeitszeitraumItem), var_export($suchprofilGueltigkeitszeitraumItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The gueltigkeitszeitraum property can only contain items of type \StructType\Zeitraum, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set gueltigkeitszeitraum value
     * @throws \InvalidArgumentException
     * @param \StructType\Zeitraum[] $gueltigkeitszeitraum
     * @return \StructType\Suchprofil
     */
    public function setGueltigkeitszeitraum(array $gueltigkeitszeitraum = array())
    {
        // validation for constraint: array
        if ('' !== ($gueltigkeitszeitraumArrayErrorMessage = self::validateGueltigkeitszeitraumForArrayConstraintsFromSetGueltigkeitszeitraum($gueltigkeitszeitraum))) {
            throw new \InvalidArgumentException($gueltigkeitszeitraumArrayErrorMessage, __LINE__);
        }
        $this->gueltigkeitszeitraum = $gueltigkeitszeitraum;
        return $this;
    }
    /**
     * Add item to gueltigkeitszeitraum value
     * @throws \InvalidArgumentException
     * @param \StructType\Zeitraum $item
     * @return \StructType\Suchprofil
     */
    public function addToGueltigkeitszeitraum(\StructType\Zeitraum $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Zeitraum) {
            throw new \InvalidArgumentException(sprintf('The gueltigkeitszeitraum property can only contain items of type \StructType\Zeitraum, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->gueltigkeitszeitraum[] = $item;
        return $this;
    }
    /**
     * Get aenderungszeitraum value
     * @return \StructType\Zeitraum[]|null
     */
    public function getAenderungszeitraum()
    {
        return $this->aenderungszeitraum;
    }
    /**
     * This method is responsible for validating the values passed to the setAenderungszeitraum method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAenderungszeitraum method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAenderungszeitraumForArrayConstraintsFromSetAenderungszeitraum(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $suchprofilAenderungszeitraumItem) {
            // validation for constraint: itemType
            if (!$suchprofilAenderungszeitraumItem instanceof \StructType\Zeitraum) {
                $invalidValues[] = is_object($suchprofilAenderungszeitraumItem) ? get_class($suchprofilAenderungszeitraumItem) : sprintf('%s(%s)', gettype($suchprofilAenderungszeitraumItem), var_export($suchprofilAenderungszeitraumItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The aenderungszeitraum property can only contain items of type \StructType\Zeitraum, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set aenderungszeitraum value
     * @throws \InvalidArgumentException
     * @param \StructType\Zeitraum[] $aenderungszeitraum
     * @return \StructType\Suchprofil
     */
    public function setAenderungszeitraum(array $aenderungszeitraum = array())
    {
        // validation for constraint: array
        if ('' !== ($aenderungszeitraumArrayErrorMessage = self::validateAenderungszeitraumForArrayConstraintsFromSetAenderungszeitraum($aenderungszeitraum))) {
            throw new \InvalidArgumentException($aenderungszeitraumArrayErrorMessage, __LINE__);
        }
        $this->aenderungszeitraum = $aenderungszeitraum;
        return $this;
    }
    /**
     * Add item to aenderungszeitraum value
     * @throws \InvalidArgumentException
     * @param \StructType\Zeitraum $item
     * @return \StructType\Suchprofil
     */
    public function addToAenderungszeitraum(\StructType\Zeitraum $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Zeitraum) {
            throw new \InvalidArgumentException(sprintf('The aenderungszeitraum property can only contain items of type \StructType\Zeitraum, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->aenderungszeitraum[] = $item;
        return $this;
    }
    /**
     * Get verfuegbareSprache value
     * @return string[]|null
     */
    public function getVerfuegbareSprache()
    {
        return $this->verfuegbareSprache;
    }
    /**
     * This method is responsible for validating the values passed to the setVerfuegbareSprache method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVerfuegbareSprache method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVerfuegbareSpracheForArrayConstraintsFromSetVerfuegbareSprache(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $suchprofilVerfuegbareSpracheItem) {
            // validation for constraint: itemType
            if (!is_string($suchprofilVerfuegbareSpracheItem)) {
                $invalidValues[] = is_object($suchprofilVerfuegbareSpracheItem) ? get_class($suchprofilVerfuegbareSpracheItem) : sprintf('%s(%s)', gettype($suchprofilVerfuegbareSpracheItem), var_export($suchprofilVerfuegbareSpracheItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The verfuegbareSprache property can only contain items of type language, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set verfuegbareSprache value
     * @throws \InvalidArgumentException
     * @param string[] $verfuegbareSprache
     * @return \StructType\Suchprofil
     */
    public function setVerfuegbareSprache(array $verfuegbareSprache = array())
    {
        // validation for constraint: array
        if ('' !== ($verfuegbareSpracheArrayErrorMessage = self::validateVerfuegbareSpracheForArrayConstraintsFromSetVerfuegbareSprache($verfuegbareSprache))) {
            throw new \InvalidArgumentException($verfuegbareSpracheArrayErrorMessage, __LINE__);
        }
        $this->verfuegbareSprache = $verfuegbareSprache;
        return $this;
    }
    /**
     * Add item to verfuegbareSprache value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Suchprofil
     */
    public function addToVerfuegbareSprache($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The verfuegbareSprache property can only contain items of type language, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->verfuegbareSprache[] = $item;
        return $this;
    }
    /**
     * Get elementfilterSprache value
     * @return string[]|null
     */
    public function getElementfilterSprache()
    {
        return $this->elementfilterSprache;
    }
    /**
     * This method is responsible for validating the values passed to the setElementfilterSprache method
     * This method is willingly generated in order to preserve the one-line inline validation within the setElementfilterSprache method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateElementfilterSpracheForArrayConstraintsFromSetElementfilterSprache(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $suchprofilElementfilterSpracheItem) {
            // validation for constraint: itemType
            if (!is_string($suchprofilElementfilterSpracheItem)) {
                $invalidValues[] = is_object($suchprofilElementfilterSpracheItem) ? get_class($suchprofilElementfilterSpracheItem) : sprintf('%s(%s)', gettype($suchprofilElementfilterSpracheItem), var_export($suchprofilElementfilterSpracheItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The elementfilterSprache property can only contain items of type language, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set elementfilterSprache value
     * @throws \InvalidArgumentException
     * @param string[] $elementfilterSprache
     * @return \StructType\Suchprofil
     */
    public function setElementfilterSprache(array $elementfilterSprache = array())
    {
        // validation for constraint: array
        if ('' !== ($elementfilterSpracheArrayErrorMessage = self::validateElementfilterSpracheForArrayConstraintsFromSetElementfilterSprache($elementfilterSprache))) {
            throw new \InvalidArgumentException($elementfilterSpracheArrayErrorMessage, __LINE__);
        }
        $this->elementfilterSprache = $elementfilterSprache;
        return $this;
    }
    /**
     * Add item to elementfilterSprache value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Suchprofil
     */
    public function addToElementfilterSprache($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The elementfilterSprache property can only contain items of type language, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->elementfilterSprache[] = $item;
        return $this;
    }
}
