<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Real_PropertyType StructType
 * @subpackage Structs
 */
class Real_PropertyType extends AbstractStructBase
{
    /**
     * The Real
     * @var float
     */
    public $Real;
    /**
     * The nilReason
     * @var string
     */
    public $nilReason;
    /**
     * Constructor method for Real_PropertyType
     * @uses Real_PropertyType::setReal()
     * @uses Real_PropertyType::setNilReason()
     * @param float $real
     * @param string $nilReason
     */
    public function __construct($real = null, $nilReason = null)
    {
        $this
            ->setReal($real)
            ->setNilReason($nilReason);
    }
    /**
     * Get Real value
     * @return float|null
     */
    public function getReal()
    {
        return $this->Real;
    }
    /**
     * Set Real value
     * @param float $real
     * @return \StructType\Real_PropertyType
     */
    public function setReal($real = null)
    {
        // validation for constraint: float
        if (!is_null($real) && !(is_float($real) || is_numeric($real))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($real, true), gettype($real)), __LINE__);
        }
        $this->Real = $real;
        return $this;
    }
    /**
     * Get nilReason value
     * @return string|null
     */
    public function getNilReason()
    {
        return $this->nilReason;
    }
    /**
     * Set nilReason value
     * @param string $nilReason
     * @return \StructType\Real_PropertyType
     */
    public function setNilReason($nilReason = null)
    {
        // validation for constraint: string
        if (!is_null($nilReason) && !is_string($nilReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nilReason, true), gettype($nilReason)), __LINE__);
        }
        $this->nilReason = $nilReason;
        return $this;
    }
}
