<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProjectedCRSType StructType
 * @subpackage Structs
 */
class ProjectedCRSType extends AbstractStructBase
{
    /**
     * The baseGeodeticCRS
     * @var \StructType\GeodeticCRSPropertyType
     */
    public $baseGeodeticCRS;
    /**
     * The baseGeographicCRS
     * @var \StructType\GeographicCRSPropertyType
     */
    public $baseGeographicCRS;
    /**
     * The cartesianCS
     * @var \StructType\CartesianCSPropertyType
     */
    public $cartesianCS;
    /**
     * Constructor method for ProjectedCRSType
     * @uses ProjectedCRSType::setBaseGeodeticCRS()
     * @uses ProjectedCRSType::setBaseGeographicCRS()
     * @uses ProjectedCRSType::setCartesianCS()
     * @param \StructType\GeodeticCRSPropertyType $baseGeodeticCRS
     * @param \StructType\GeographicCRSPropertyType $baseGeographicCRS
     * @param \StructType\CartesianCSPropertyType $cartesianCS
     */
    public function __construct(\StructType\GeodeticCRSPropertyType $baseGeodeticCRS = null, \StructType\GeographicCRSPropertyType $baseGeographicCRS = null, \StructType\CartesianCSPropertyType $cartesianCS = null)
    {
        $this
            ->setBaseGeodeticCRS($baseGeodeticCRS)
            ->setBaseGeographicCRS($baseGeographicCRS)
            ->setCartesianCS($cartesianCS);
    }
    /**
     * Get baseGeodeticCRS value
     * @return \StructType\GeodeticCRSPropertyType|null
     */
    public function getBaseGeodeticCRS()
    {
        return $this->baseGeodeticCRS;
    }
    /**
     * Set baseGeodeticCRS value
     * @param \StructType\GeodeticCRSPropertyType $baseGeodeticCRS
     * @return \StructType\ProjectedCRSType
     */
    public function setBaseGeodeticCRS(\StructType\GeodeticCRSPropertyType $baseGeodeticCRS = null)
    {
        $this->baseGeodeticCRS = $baseGeodeticCRS;
        return $this;
    }
    /**
     * Get baseGeographicCRS value
     * @return \StructType\GeographicCRSPropertyType|null
     */
    public function getBaseGeographicCRS()
    {
        return $this->baseGeographicCRS;
    }
    /**
     * Set baseGeographicCRS value
     * @param \StructType\GeographicCRSPropertyType $baseGeographicCRS
     * @return \StructType\ProjectedCRSType
     */
    public function setBaseGeographicCRS(\StructType\GeographicCRSPropertyType $baseGeographicCRS = null)
    {
        $this->baseGeographicCRS = $baseGeographicCRS;
        return $this;
    }
    /**
     * Get cartesianCS value
     * @return \StructType\CartesianCSPropertyType|null
     */
    public function getCartesianCS()
    {
        return $this->cartesianCS;
    }
    /**
     * Set cartesianCS value
     * @param \StructType\CartesianCSPropertyType $cartesianCS
     * @return \StructType\ProjectedCRSType
     */
    public function setCartesianCS(\StructType\CartesianCSPropertyType $cartesianCS = null)
    {
        $this->cartesianCS = $cartesianCS;
        return $this;
    }
}
