<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PointArrayPropertyType StructType
 * @subpackage Structs
 */
class PointArrayPropertyType extends AbstractStructBase
{
    /**
     * The Point
     * @var \StructType\PointType
     */
    public $Point;
    /**
     * The owns
     * @var bool
     */
    public $owns;
    /**
     * Constructor method for PointArrayPropertyType
     * @uses PointArrayPropertyType::setPoint()
     * @uses PointArrayPropertyType::setOwns()
     * @param \StructType\PointType $point
     * @param bool $owns
     */
    public function __construct(\StructType\PointType $point = null, $owns = null)
    {
        $this
            ->setPoint($point)
            ->setOwns($owns);
    }
    /**
     * Get Point value
     * @return \StructType\PointType|null
     */
    public function getPoint()
    {
        return $this->Point;
    }
    /**
     * Set Point value
     * @param \StructType\PointType $point
     * @return \StructType\PointArrayPropertyType
     */
    public function setPoint(\StructType\PointType $point = null)
    {
        $this->Point = $point;
        return $this;
    }
    /**
     * Get owns value
     * @return bool|null
     */
    public function getOwns()
    {
        return $this->owns;
    }
    /**
     * Set owns value
     * @param bool $owns
     * @return \StructType\PointArrayPropertyType
     */
    public function setOwns($owns = null)
    {
        // validation for constraint: boolean
        if (!is_null($owns) && !is_bool($owns)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($owns, true), gettype($owns)), __LINE__);
        }
        $this->owns = $owns;
        return $this;
    }
}
