<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrientableCurveType StructType
 * @subpackage Structs
 */
class OrientableCurveType extends AbstractStructBase
{
    /**
     * The baseCurve
     * @var \StructType\CurvePropertyType
     */
    public $baseCurve;
    /**
     * The orientation
     * @var string
     */
    public $orientation;
    /**
     * Constructor method for OrientableCurveType
     * @uses OrientableCurveType::setBaseCurve()
     * @uses OrientableCurveType::setOrientation()
     * @param \StructType\CurvePropertyType $baseCurve
     * @param string $orientation
     */
    public function __construct(\StructType\CurvePropertyType $baseCurve = null, $orientation = null)
    {
        $this
            ->setBaseCurve($baseCurve)
            ->setOrientation($orientation);
    }
    /**
     * Get baseCurve value
     * @return \StructType\CurvePropertyType|null
     */
    public function getBaseCurve()
    {
        return $this->baseCurve;
    }
    /**
     * Set baseCurve value
     * @param \StructType\CurvePropertyType $baseCurve
     * @return \StructType\OrientableCurveType
     */
    public function setBaseCurve(\StructType\CurvePropertyType $baseCurve = null)
    {
        $this->baseCurve = $baseCurve;
        return $this;
    }
    /**
     * Get orientation value
     * @return string|null
     */
    public function getOrientation()
    {
        return $this->orientation;
    }
    /**
     * Set orientation value
     * @param string $orientation
     * @return \StructType\OrientableCurveType
     */
    public function setOrientation($orientation = null)
    {
        // validation for constraint: string
        if (!is_null($orientation) && !is_string($orientation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orientation, true), gettype($orientation)), __LINE__);
        }
        $this->orientation = $orientation;
        return $this;
    }
}
