<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OnlinedienstErweitert StructType
 * Meta information extracted from the WSDL
 * - documentation: Erweiterter Datentyp für Onlinedienste zur Übertragung von Zuständigkeiten.
 * @subpackage Structs
 */
class OnlinedienstErweitert extends Onlinedienst
{
    /**
     * The zustaendigkeit
     * Meta information extracted from the WSDL
     * - documentation: Angabe der Zuständigkeiten des Onlinedienstes.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Zustaendigkeit[]
     */
    public $zustaendigkeit;
    /**
     * Constructor method for OnlinedienstErweitert
     * @uses OnlinedienstErweitert::setZustaendigkeit()
     * @param \StructType\Zustaendigkeit[] $zustaendigkeit
     */
    public function __construct(array $zustaendigkeit = array())
    {
        $this
            ->setZustaendigkeit($zustaendigkeit);
    }
    /**
     * Get zustaendigkeit value
     * @return \StructType\Zustaendigkeit[]|null
     */
    public function getZustaendigkeit()
    {
        return $this->zustaendigkeit;
    }
    /**
     * This method is responsible for validating the values passed to the setZustaendigkeit method
     * This method is willingly generated in order to preserve the one-line inline validation within the setZustaendigkeit method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateZustaendigkeitForArrayConstraintsFromSetZustaendigkeit(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $onlinedienstErweitertZustaendigkeitItem) {
            // validation for constraint: itemType
            if (!$onlinedienstErweitertZustaendigkeitItem instanceof \StructType\Zustaendigkeit) {
                $invalidValues[] = is_object($onlinedienstErweitertZustaendigkeitItem) ? get_class($onlinedienstErweitertZustaendigkeitItem) : sprintf('%s(%s)', gettype($onlinedienstErweitertZustaendigkeitItem), var_export($onlinedienstErweitertZustaendigkeitItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The zustaendigkeit property can only contain items of type \StructType\Zustaendigkeit, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set zustaendigkeit value
     * @throws \InvalidArgumentException
     * @param \StructType\Zustaendigkeit[] $zustaendigkeit
     * @return \StructType\OnlinedienstErweitert
     */
    public function setZustaendigkeit(array $zustaendigkeit = array())
    {
        // validation for constraint: array
        if ('' !== ($zustaendigkeitArrayErrorMessage = self::validateZustaendigkeitForArrayConstraintsFromSetZustaendigkeit($zustaendigkeit))) {
            throw new \InvalidArgumentException($zustaendigkeitArrayErrorMessage, __LINE__);
        }
        $this->zustaendigkeit = $zustaendigkeit;
        return $this;
    }
    /**
     * Add item to zustaendigkeit value
     * @throws \InvalidArgumentException
     * @param \StructType\Zustaendigkeit $item
     * @return \StructType\OnlinedienstErweitert
     */
    public function addToZustaendigkeit(\StructType\Zustaendigkeit $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Zustaendigkeit) {
            throw new \InvalidArgumentException(sprintf('The zustaendigkeit property can only contain items of type \StructType\Zustaendigkeit, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->zustaendigkeit[] = $item;
        return $this;
    }
}
