<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OffsetCurveType StructType
 * @subpackage Structs
 */
class OffsetCurveType extends AbstractStructBase
{
    /**
     * The offsetBase
     * @var \StructType\CurvePropertyType
     */
    public $offsetBase;
    /**
     * The distance
     * @var \StructType\LengthType
     */
    public $distance;
    /**
     * The refDirection
     * @var \StructType\VectorType
     */
    public $refDirection;
    /**
     * Constructor method for OffsetCurveType
     * @uses OffsetCurveType::setOffsetBase()
     * @uses OffsetCurveType::setDistance()
     * @uses OffsetCurveType::setRefDirection()
     * @param \StructType\CurvePropertyType $offsetBase
     * @param \StructType\LengthType $distance
     * @param \StructType\VectorType $refDirection
     */
    public function __construct(\StructType\CurvePropertyType $offsetBase = null, \StructType\LengthType $distance = null, \StructType\VectorType $refDirection = null)
    {
        $this
            ->setOffsetBase($offsetBase)
            ->setDistance($distance)
            ->setRefDirection($refDirection);
    }
    /**
     * Get offsetBase value
     * @return \StructType\CurvePropertyType|null
     */
    public function getOffsetBase()
    {
        return $this->offsetBase;
    }
    /**
     * Set offsetBase value
     * @param \StructType\CurvePropertyType $offsetBase
     * @return \StructType\OffsetCurveType
     */
    public function setOffsetBase(\StructType\CurvePropertyType $offsetBase = null)
    {
        $this->offsetBase = $offsetBase;
        return $this;
    }
    /**
     * Get distance value
     * @return \StructType\LengthType|null
     */
    public function getDistance()
    {
        return $this->distance;
    }
    /**
     * Set distance value
     * @param \StructType\LengthType $distance
     * @return \StructType\OffsetCurveType
     */
    public function setDistance(\StructType\LengthType $distance = null)
    {
        $this->distance = $distance;
        return $this;
    }
    /**
     * Get refDirection value
     * @return \StructType\VectorType|null
     */
    public function getRefDirection()
    {
        return $this->refDirection;
    }
    /**
     * Set refDirection value
     * @param \StructType\VectorType $refDirection
     * @return \StructType\OffsetCurveType
     */
    public function setRefDirection(\StructType\VectorType $refDirection = null)
    {
        $this->refDirection = $refDirection;
        return $this;
    }
}
