<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NodePropertyType StructType
 * @subpackage Structs
 */
class NodePropertyType extends AbstractStructBase
{
    /**
     * The Node
     * @var \StructType\NodeType
     */
    public $Node;
    /**
     * The nilReason
     * @var string
     */
    public $nilReason;
    /**
     * The remoteSchema
     * @var string
     */
    public $remoteSchema;
    /**
     * The type
     * @var string
     */
    public $type;
    /**
     * The href
     * @var string
     */
    public $href;
    /**
     * The role
     * @var string
     */
    public $role;
    /**
     * The arcrole
     * @var string
     */
    public $arcrole;
    /**
     * The title
     * @var string
     */
    public $title;
    /**
     * The show
     * @var string
     */
    public $show;
    /**
     * The actuate
     * @var string
     */
    public $actuate;
    /**
     * The owns
     * @var bool
     */
    public $owns;
    /**
     * Constructor method for NodePropertyType
     * @uses NodePropertyType::setNode()
     * @uses NodePropertyType::setNilReason()
     * @uses NodePropertyType::setRemoteSchema()
     * @uses NodePropertyType::setType()
     * @uses NodePropertyType::setHref()
     * @uses NodePropertyType::setRole()
     * @uses NodePropertyType::setArcrole()
     * @uses NodePropertyType::setTitle()
     * @uses NodePropertyType::setShow()
     * @uses NodePropertyType::setActuate()
     * @uses NodePropertyType::setOwns()
     * @param \StructType\NodeType $node
     * @param string $nilReason
     * @param string $remoteSchema
     * @param string $type
     * @param string $href
     * @param string $role
     * @param string $arcrole
     * @param string $title
     * @param string $show
     * @param string $actuate
     * @param bool $owns
     */
    public function __construct(\StructType\NodeType $node = null, $nilReason = null, $remoteSchema = null, $type = null, $href = null, $role = null, $arcrole = null, $title = null, $show = null, $actuate = null, $owns = null)
    {
        $this
            ->setNode($node)
            ->setNilReason($nilReason)
            ->setRemoteSchema($remoteSchema)
            ->setType($type)
            ->setHref($href)
            ->setRole($role)
            ->setArcrole($arcrole)
            ->setTitle($title)
            ->setShow($show)
            ->setActuate($actuate)
            ->setOwns($owns);
    }
    /**
     * Get Node value
     * @return \StructType\NodeType|null
     */
    public function getNode()
    {
        return $this->Node;
    }
    /**
     * Set Node value
     * @param \StructType\NodeType $node
     * @return \StructType\NodePropertyType
     */
    public function setNode(\StructType\NodeType $node = null)
    {
        $this->Node = $node;
        return $this;
    }
    /**
     * Get nilReason value
     * @return string|null
     */
    public function getNilReason()
    {
        return $this->nilReason;
    }
    /**
     * Set nilReason value
     * @param string $nilReason
     * @return \StructType\NodePropertyType
     */
    public function setNilReason($nilReason = null)
    {
        // validation for constraint: string
        if (!is_null($nilReason) && !is_string($nilReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nilReason, true), gettype($nilReason)), __LINE__);
        }
        $this->nilReason = $nilReason;
        return $this;
    }
    /**
     * Get remoteSchema value
     * @return string|null
     */
    public function getRemoteSchema()
    {
        return $this->remoteSchema;
    }
    /**
     * Set remoteSchema value
     * @param string $remoteSchema
     * @return \StructType\NodePropertyType
     */
    public function setRemoteSchema($remoteSchema = null)
    {
        // validation for constraint: string
        if (!is_null($remoteSchema) && !is_string($remoteSchema)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remoteSchema, true), gettype($remoteSchema)), __LINE__);
        }
        $this->remoteSchema = $remoteSchema;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \StructType\NodePropertyType
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get href value
     * @return string|null
     */
    public function getHref()
    {
        return $this->href;
    }
    /**
     * Set href value
     * @param string $href
     * @return \StructType\NodePropertyType
     */
    public function setHref($href = null)
    {
        // validation for constraint: string
        if (!is_null($href) && !is_string($href)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($href, true), gettype($href)), __LINE__);
        }
        $this->href = $href;
        return $this;
    }
    /**
     * Get role value
     * @return string|null
     */
    public function getRole()
    {
        return $this->role;
    }
    /**
     * Set role value
     * @param string $role
     * @return \StructType\NodePropertyType
     */
    public function setRole($role = null)
    {
        // validation for constraint: string
        if (!is_null($role) && !is_string($role)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($role, true), gettype($role)), __LINE__);
        }
        $this->role = $role;
        return $this;
    }
    /**
     * Get arcrole value
     * @return string|null
     */
    public function getArcrole()
    {
        return $this->arcrole;
    }
    /**
     * Set arcrole value
     * @param string $arcrole
     * @return \StructType\NodePropertyType
     */
    public function setArcrole($arcrole = null)
    {
        // validation for constraint: string
        if (!is_null($arcrole) && !is_string($arcrole)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arcrole, true), gettype($arcrole)), __LINE__);
        }
        $this->arcrole = $arcrole;
        return $this;
    }
    /**
     * Get title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * Set title value
     * @param string $title
     * @return \StructType\NodePropertyType
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->title = $title;
        return $this;
    }
    /**
     * Get show value
     * @return string|null
     */
    public function getShow()
    {
        return $this->show;
    }
    /**
     * Set show value
     * @param string $show
     * @return \StructType\NodePropertyType
     */
    public function setShow($show = null)
    {
        // validation for constraint: string
        if (!is_null($show) && !is_string($show)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($show, true), gettype($show)), __LINE__);
        }
        $this->show = $show;
        return $this;
    }
    /**
     * Get actuate value
     * @return string|null
     */
    public function getActuate()
    {
        return $this->actuate;
    }
    /**
     * Set actuate value
     * @param string $actuate
     * @return \StructType\NodePropertyType
     */
    public function setActuate($actuate = null)
    {
        // validation for constraint: string
        if (!is_null($actuate) && !is_string($actuate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actuate, true), gettype($actuate)), __LINE__);
        }
        $this->actuate = $actuate;
        return $this;
    }
    /**
     * Get owns value
     * @return bool|null
     */
    public function getOwns()
    {
        return $this->owns;
    }
    /**
     * Set owns value
     * @param bool $owns
     * @return \StructType\NodePropertyType
     */
    public function setOwns($owns = null)
    {
        // validation for constraint: boolean
        if (!is_null($owns) && !is_bool($owns)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($owns, true), gettype($owns)), __LINE__);
        }
        $this->owns = $owns;
        return $this;
    }
}
