<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Nachrichtenkopf StructType
 * Meta information extracted from the WSDL
 * - documentation: Kopf (header) einer Nachricht. Enthält Informationen zum Absender, Empfänger, Zeitpunkt der Erstellung und Identifikation der Nachricht.
 * @subpackage Structs
 */
class Nachrichtenkopf extends AbstractStructBase
{
    /**
     * The nachrichtUUID
     * Meta information extracted from the WSDL
     * - documentation: UUID (Universally Unique Identifier) der Nachricht. Z.B. "550e8400-e29b-11d4-a716-446655440000"
     * @var string
     */
    public $nachrichtUUID;
    /**
     * The erstelltDatumZeit
     * Meta information extracted from the WSDL
     * - documentation: Erstelldatum und -zeit der Nachricht.
     * @var string
     */
    public $erstelltDatumZeit;
    /**
     * The empfaenger
     * Meta information extracted from the WSDL
     * - documentation: Empfänger der Nachricht.
     * - minOccurs: 0
     * @var string
     */
    public $empfaenger;
    /**
     * The sender
     * Meta information extracted from the WSDL
     * - documentation: Absender der Nachricht.
     * - minOccurs: 0
     * @var string
     */
    public $sender;
    /**
     * Constructor method for Nachrichtenkopf
     * @uses Nachrichtenkopf::setNachrichtUUID()
     * @uses Nachrichtenkopf::setErstelltDatumZeit()
     * @uses Nachrichtenkopf::setEmpfaenger()
     * @uses Nachrichtenkopf::setSender()
     * @param string $nachrichtUUID
     * @param string $erstelltDatumZeit
     * @param string $empfaenger
     * @param string $sender
     */
    public function __construct($nachrichtUUID = null, $erstelltDatumZeit = null, $empfaenger = null, $sender = null)
    {
        $this
            ->setNachrichtUUID($nachrichtUUID)
            ->setErstelltDatumZeit($erstelltDatumZeit)
            ->setEmpfaenger($empfaenger)
            ->setSender($sender);
    }
    /**
     * Get nachrichtUUID value
     * @return string|null
     */
    public function getNachrichtUUID()
    {
        return $this->nachrichtUUID;
    }
    /**
     * Set nachrichtUUID value
     * @param string $nachrichtUUID
     * @return \StructType\Nachrichtenkopf
     */
    public function setNachrichtUUID($nachrichtUUID = null)
    {
        // validation for constraint: string
        if (!is_null($nachrichtUUID) && !is_string($nachrichtUUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nachrichtUUID, true), gettype($nachrichtUUID)), __LINE__);
        }
        $this->nachrichtUUID = $nachrichtUUID;
        return $this;
    }
    /**
     * Get erstelltDatumZeit value
     * @return string|null
     */
    public function getErstelltDatumZeit()
    {
        return $this->erstelltDatumZeit;
    }
    /**
     * Set erstelltDatumZeit value
     * @param string $erstelltDatumZeit
     * @return \StructType\Nachrichtenkopf
     */
    public function setErstelltDatumZeit($erstelltDatumZeit = null)
    {
        // validation for constraint: string
        if (!is_null($erstelltDatumZeit) && !is_string($erstelltDatumZeit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($erstelltDatumZeit, true), gettype($erstelltDatumZeit)), __LINE__);
        }
        $this->erstelltDatumZeit = $erstelltDatumZeit;
        return $this;
    }
    /**
     * Get empfaenger value
     * @return string|null
     */
    public function getEmpfaenger()
    {
        return $this->empfaenger;
    }
    /**
     * Set empfaenger value
     * @param string $empfaenger
     * @return \StructType\Nachrichtenkopf
     */
    public function setEmpfaenger($empfaenger = null)
    {
        // validation for constraint: string
        if (!is_null($empfaenger) && !is_string($empfaenger)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($empfaenger, true), gettype($empfaenger)), __LINE__);
        }
        $this->empfaenger = $empfaenger;
        return $this;
    }
    /**
     * Get sender value
     * @return string|null
     */
    public function getSender()
    {
        return $this->sender;
    }
    /**
     * Set sender value
     * @param string $sender
     * @return \StructType\Nachrichtenkopf
     */
    public function setSender($sender = null)
    {
        // validation for constraint: string
        if (!is_null($sender) && !is_string($sender)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sender, true), gettype($sender)), __LINE__);
        }
        $this->sender = $sender;
        return $this;
    }
}
