<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MultiGeometryType StructType
 * @subpackage Structs
 */
class MultiGeometryType extends AbstractStructBase
{
    /**
     * The geometryMember
     * @var \StructType\GeometryPropertyType
     */
    public $geometryMember;
    /**
     * The geometryMembers
     * @var \StructType\GeometryArrayPropertyType
     */
    public $geometryMembers;
    /**
     * Constructor method for MultiGeometryType
     * @uses MultiGeometryType::setGeometryMember()
     * @uses MultiGeometryType::setGeometryMembers()
     * @param \StructType\GeometryPropertyType $geometryMember
     * @param \StructType\GeometryArrayPropertyType $geometryMembers
     */
    public function __construct(\StructType\GeometryPropertyType $geometryMember = null, \StructType\GeometryArrayPropertyType $geometryMembers = null)
    {
        $this
            ->setGeometryMember($geometryMember)
            ->setGeometryMembers($geometryMembers);
    }
    /**
     * Get geometryMember value
     * @return \StructType\GeometryPropertyType|null
     */
    public function getGeometryMember()
    {
        return $this->geometryMember;
    }
    /**
     * Set geometryMember value
     * @param \StructType\GeometryPropertyType $geometryMember
     * @return \StructType\MultiGeometryType
     */
    public function setGeometryMember(\StructType\GeometryPropertyType $geometryMember = null)
    {
        $this->geometryMember = $geometryMember;
        return $this;
    }
    /**
     * Get geometryMembers value
     * @return \StructType\GeometryArrayPropertyType|null
     */
    public function getGeometryMembers()
    {
        return $this->geometryMembers;
    }
    /**
     * Set geometryMembers value
     * @param \StructType\GeometryArrayPropertyType $geometryMembers
     * @return \StructType\MultiGeometryType
     */
    public function setGeometryMembers(\StructType\GeometryArrayPropertyType $geometryMembers = null)
    {
        $this->geometryMembers = $geometryMembers;
        return $this;
    }
}
