<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MD_Metadata_Type StructType
 * @subpackage Structs
 */
class MD_Metadata_Type extends AbstractStructBase
{
    /**
     * The fileIdentifier
     * @var \StructType\CharacterString_PropertyType
     */
    public $fileIdentifier;
    /**
     * The language
     * @var \StructType\CharacterString_PropertyType
     */
    public $language;
    /**
     * The characterSet
     * @var \StructType\MD_CharacterSetCode_PropertyType
     */
    public $characterSet;
    /**
     * The parentIdentifier
     * @var \StructType\CharacterString_PropertyType
     */
    public $parentIdentifier;
    /**
     * The hierarchyLevel
     * @var \StructType\MD_ScopeCode_PropertyType
     */
    public $hierarchyLevel;
    /**
     * The hierarchyLevelName
     * @var \StructType\CharacterString_PropertyType
     */
    public $hierarchyLevelName;
    /**
     * The contact
     * @var \StructType\CI_ResponsibleParty_PropertyType
     */
    public $contact;
    /**
     * The dateStamp
     * @var \StructType\Date_PropertyType
     */
    public $dateStamp;
    /**
     * The metadataStandardName
     * @var \StructType\CharacterString_PropertyType
     */
    public $metadataStandardName;
    /**
     * The metadataStandardVersion
     * @var \StructType\CharacterString_PropertyType
     */
    public $metadataStandardVersion;
    /**
     * The dataSetURI
     * @var \StructType\CharacterString_PropertyType
     */
    public $dataSetURI;
    /**
     * The locale
     * @var \StructType\PT_Locale_PropertyType
     */
    public $locale;
    /**
     * The spatialRepresentationInfo
     * @var \StructType\MD_SpatialRepresentation_PropertyType
     */
    public $spatialRepresentationInfo;
    /**
     * The referenceSystemInfo
     * @var \StructType\MD_ReferenceSystem_PropertyType
     */
    public $referenceSystemInfo;
    /**
     * The metadataExtensionInfo
     * @var \StructType\MD_MetadataExtensionInformation_PropertyType
     */
    public $metadataExtensionInfo;
    /**
     * The identificationInfo
     * @var \StructType\MD_Identification_PropertyType
     */
    public $identificationInfo;
    /**
     * The contentInfo
     * @var \StructType\MD_ContentInformation_PropertyType
     */
    public $contentInfo;
    /**
     * The distributionInfo
     * @var \StructType\MD_Distribution_PropertyType
     */
    public $distributionInfo;
    /**
     * The dataQualityInfo
     * @var \StructType\DQ_DataQuality_PropertyType
     */
    public $dataQualityInfo;
    /**
     * The portrayalCatalogueInfo
     * @var \StructType\MD_PortrayalCatalogueReference_PropertyType
     */
    public $portrayalCatalogueInfo;
    /**
     * The metadataConstraints
     * @var \StructType\MD_Constraints_PropertyType
     */
    public $metadataConstraints;
    /**
     * The applicationSchemaInfo
     * @var \StructType\MD_ApplicationSchemaInformation_PropertyType
     */
    public $applicationSchemaInfo;
    /**
     * The metadataMaintenance
     * @var \StructType\MD_MaintenanceInformation_PropertyType
     */
    public $metadataMaintenance;
    /**
     * The series
     * @var \StructType\DS_Aggregate_PropertyType
     */
    public $series;
    /**
     * The describes
     * @var \StructType\DS_DataSet_PropertyType
     */
    public $describes;
    /**
     * The propertyType
     * @var \StructType\ObjectReference_PropertyType
     */
    public $propertyType;
    /**
     * The featureType
     * @var \StructType\ObjectReference_PropertyType
     */
    public $featureType;
    /**
     * The featureAttribute
     * @var \StructType\ObjectReference_PropertyType
     */
    public $featureAttribute;
    /**
     * Constructor method for MD_Metadata_Type
     * @uses MD_Metadata_Type::setFileIdentifier()
     * @uses MD_Metadata_Type::setLanguage()
     * @uses MD_Metadata_Type::setCharacterSet()
     * @uses MD_Metadata_Type::setParentIdentifier()
     * @uses MD_Metadata_Type::setHierarchyLevel()
     * @uses MD_Metadata_Type::setHierarchyLevelName()
     * @uses MD_Metadata_Type::setContact()
     * @uses MD_Metadata_Type::setDateStamp()
     * @uses MD_Metadata_Type::setMetadataStandardName()
     * @uses MD_Metadata_Type::setMetadataStandardVersion()
     * @uses MD_Metadata_Type::setDataSetURI()
     * @uses MD_Metadata_Type::setLocale()
     * @uses MD_Metadata_Type::setSpatialRepresentationInfo()
     * @uses MD_Metadata_Type::setReferenceSystemInfo()
     * @uses MD_Metadata_Type::setMetadataExtensionInfo()
     * @uses MD_Metadata_Type::setIdentificationInfo()
     * @uses MD_Metadata_Type::setContentInfo()
     * @uses MD_Metadata_Type::setDistributionInfo()
     * @uses MD_Metadata_Type::setDataQualityInfo()
     * @uses MD_Metadata_Type::setPortrayalCatalogueInfo()
     * @uses MD_Metadata_Type::setMetadataConstraints()
     * @uses MD_Metadata_Type::setApplicationSchemaInfo()
     * @uses MD_Metadata_Type::setMetadataMaintenance()
     * @uses MD_Metadata_Type::setSeries()
     * @uses MD_Metadata_Type::setDescribes()
     * @uses MD_Metadata_Type::setPropertyType()
     * @uses MD_Metadata_Type::setFeatureType()
     * @uses MD_Metadata_Type::setFeatureAttribute()
     * @param \StructType\CharacterString_PropertyType $fileIdentifier
     * @param \StructType\CharacterString_PropertyType $language
     * @param \StructType\MD_CharacterSetCode_PropertyType $characterSet
     * @param \StructType\CharacterString_PropertyType $parentIdentifier
     * @param \StructType\MD_ScopeCode_PropertyType $hierarchyLevel
     * @param \StructType\CharacterString_PropertyType $hierarchyLevelName
     * @param \StructType\CI_ResponsibleParty_PropertyType $contact
     * @param \StructType\Date_PropertyType $dateStamp
     * @param \StructType\CharacterString_PropertyType $metadataStandardName
     * @param \StructType\CharacterString_PropertyType $metadataStandardVersion
     * @param \StructType\CharacterString_PropertyType $dataSetURI
     * @param \StructType\PT_Locale_PropertyType $locale
     * @param \StructType\MD_SpatialRepresentation_PropertyType $spatialRepresentationInfo
     * @param \StructType\MD_ReferenceSystem_PropertyType $referenceSystemInfo
     * @param \StructType\MD_MetadataExtensionInformation_PropertyType $metadataExtensionInfo
     * @param \StructType\MD_Identification_PropertyType $identificationInfo
     * @param \StructType\MD_ContentInformation_PropertyType $contentInfo
     * @param \StructType\MD_Distribution_PropertyType $distributionInfo
     * @param \StructType\DQ_DataQuality_PropertyType $dataQualityInfo
     * @param \StructType\MD_PortrayalCatalogueReference_PropertyType $portrayalCatalogueInfo
     * @param \StructType\MD_Constraints_PropertyType $metadataConstraints
     * @param \StructType\MD_ApplicationSchemaInformation_PropertyType $applicationSchemaInfo
     * @param \StructType\MD_MaintenanceInformation_PropertyType $metadataMaintenance
     * @param \StructType\DS_Aggregate_PropertyType $series
     * @param \StructType\DS_DataSet_PropertyType $describes
     * @param \StructType\ObjectReference_PropertyType $propertyType
     * @param \StructType\ObjectReference_PropertyType $featureType
     * @param \StructType\ObjectReference_PropertyType $featureAttribute
     */
    public function __construct(\StructType\CharacterString_PropertyType $fileIdentifier = null, \StructType\CharacterString_PropertyType $language = null, \StructType\MD_CharacterSetCode_PropertyType $characterSet = null, \StructType\CharacterString_PropertyType $parentIdentifier = null, \StructType\MD_ScopeCode_PropertyType $hierarchyLevel = null, \StructType\CharacterString_PropertyType $hierarchyLevelName = null, \StructType\CI_ResponsibleParty_PropertyType $contact = null, \StructType\Date_PropertyType $dateStamp = null, \StructType\CharacterString_PropertyType $metadataStandardName = null, \StructType\CharacterString_PropertyType $metadataStandardVersion = null, \StructType\CharacterString_PropertyType $dataSetURI = null, \StructType\PT_Locale_PropertyType $locale = null, \StructType\MD_SpatialRepresentation_PropertyType $spatialRepresentationInfo = null, \StructType\MD_ReferenceSystem_PropertyType $referenceSystemInfo = null, \StructType\MD_MetadataExtensionInformation_PropertyType $metadataExtensionInfo = null, \StructType\MD_Identification_PropertyType $identificationInfo = null, \StructType\MD_ContentInformation_PropertyType $contentInfo = null, \StructType\MD_Distribution_PropertyType $distributionInfo = null, \StructType\DQ_DataQuality_PropertyType $dataQualityInfo = null, \StructType\MD_PortrayalCatalogueReference_PropertyType $portrayalCatalogueInfo = null, \StructType\MD_Constraints_PropertyType $metadataConstraints = null, \StructType\MD_ApplicationSchemaInformation_PropertyType $applicationSchemaInfo = null, \StructType\MD_MaintenanceInformation_PropertyType $metadataMaintenance = null, \StructType\DS_Aggregate_PropertyType $series = null, \StructType\DS_DataSet_PropertyType $describes = null, \StructType\ObjectReference_PropertyType $propertyType = null, \StructType\ObjectReference_PropertyType $featureType = null, \StructType\ObjectReference_PropertyType $featureAttribute = null)
    {
        $this
            ->setFileIdentifier($fileIdentifier)
            ->setLanguage($language)
            ->setCharacterSet($characterSet)
            ->setParentIdentifier($parentIdentifier)
            ->setHierarchyLevel($hierarchyLevel)
            ->setHierarchyLevelName($hierarchyLevelName)
            ->setContact($contact)
            ->setDateStamp($dateStamp)
            ->setMetadataStandardName($metadataStandardName)
            ->setMetadataStandardVersion($metadataStandardVersion)
            ->setDataSetURI($dataSetURI)
            ->setLocale($locale)
            ->setSpatialRepresentationInfo($spatialRepresentationInfo)
            ->setReferenceSystemInfo($referenceSystemInfo)
            ->setMetadataExtensionInfo($metadataExtensionInfo)
            ->setIdentificationInfo($identificationInfo)
            ->setContentInfo($contentInfo)
            ->setDistributionInfo($distributionInfo)
            ->setDataQualityInfo($dataQualityInfo)
            ->setPortrayalCatalogueInfo($portrayalCatalogueInfo)
            ->setMetadataConstraints($metadataConstraints)
            ->setApplicationSchemaInfo($applicationSchemaInfo)
            ->setMetadataMaintenance($metadataMaintenance)
            ->setSeries($series)
            ->setDescribes($describes)
            ->setPropertyType($propertyType)
            ->setFeatureType($featureType)
            ->setFeatureAttribute($featureAttribute);
    }
    /**
     * Get fileIdentifier value
     * @return \StructType\CharacterString_PropertyType|null
     */
    public function getFileIdentifier()
    {
        return $this->fileIdentifier;
    }
    /**
     * Set fileIdentifier value
     * @param \StructType\CharacterString_PropertyType $fileIdentifier
     * @return \StructType\MD_Metadata_Type
     */
    public function setFileIdentifier(\StructType\CharacterString_PropertyType $fileIdentifier = null)
    {
        $this->fileIdentifier = $fileIdentifier;
        return $this;
    }
    /**
     * Get language value
     * @return \StructType\CharacterString_PropertyType|null
     */
    public function getLanguage()
    {
        return $this->language;
    }
    /**
     * Set language value
     * @param \StructType\CharacterString_PropertyType $language
     * @return \StructType\MD_Metadata_Type
     */
    public function setLanguage(\StructType\CharacterString_PropertyType $language = null)
    {
        $this->language = $language;
        return $this;
    }
    /**
     * Get characterSet value
     * @return \StructType\MD_CharacterSetCode_PropertyType|null
     */
    public function getCharacterSet()
    {
        return $this->characterSet;
    }
    /**
     * Set characterSet value
     * @param \StructType\MD_CharacterSetCode_PropertyType $characterSet
     * @return \StructType\MD_Metadata_Type
     */
    public function setCharacterSet(\StructType\MD_CharacterSetCode_PropertyType $characterSet = null)
    {
        $this->characterSet = $characterSet;
        return $this;
    }
    /**
     * Get parentIdentifier value
     * @return \StructType\CharacterString_PropertyType|null
     */
    public function getParentIdentifier()
    {
        return $this->parentIdentifier;
    }
    /**
     * Set parentIdentifier value
     * @param \StructType\CharacterString_PropertyType $parentIdentifier
     * @return \StructType\MD_Metadata_Type
     */
    public function setParentIdentifier(\StructType\CharacterString_PropertyType $parentIdentifier = null)
    {
        $this->parentIdentifier = $parentIdentifier;
        return $this;
    }
    /**
     * Get hierarchyLevel value
     * @return \StructType\MD_ScopeCode_PropertyType|null
     */
    public function getHierarchyLevel()
    {
        return $this->hierarchyLevel;
    }
    /**
     * Set hierarchyLevel value
     * @param \StructType\MD_ScopeCode_PropertyType $hierarchyLevel
     * @return \StructType\MD_Metadata_Type
     */
    public function setHierarchyLevel(\StructType\MD_ScopeCode_PropertyType $hierarchyLevel = null)
    {
        $this->hierarchyLevel = $hierarchyLevel;
        return $this;
    }
    /**
     * Get hierarchyLevelName value
     * @return \StructType\CharacterString_PropertyType|null
     */
    public function getHierarchyLevelName()
    {
        return $this->hierarchyLevelName;
    }
    /**
     * Set hierarchyLevelName value
     * @param \StructType\CharacterString_PropertyType $hierarchyLevelName
     * @return \StructType\MD_Metadata_Type
     */
    public function setHierarchyLevelName(\StructType\CharacterString_PropertyType $hierarchyLevelName = null)
    {
        $this->hierarchyLevelName = $hierarchyLevelName;
        return $this;
    }
    /**
     * Get contact value
     * @return \StructType\CI_ResponsibleParty_PropertyType|null
     */
    public function getContact()
    {
        return $this->contact;
    }
    /**
     * Set contact value
     * @param \StructType\CI_ResponsibleParty_PropertyType $contact
     * @return \StructType\MD_Metadata_Type
     */
    public function setContact(\StructType\CI_ResponsibleParty_PropertyType $contact = null)
    {
        $this->contact = $contact;
        return $this;
    }
    /**
     * Get dateStamp value
     * @return \StructType\Date_PropertyType|null
     */
    public function getDateStamp()
    {
        return $this->dateStamp;
    }
    /**
     * Set dateStamp value
     * @param \StructType\Date_PropertyType $dateStamp
     * @return \StructType\MD_Metadata_Type
     */
    public function setDateStamp(\StructType\Date_PropertyType $dateStamp = null)
    {
        $this->dateStamp = $dateStamp;
        return $this;
    }
    /**
     * Get metadataStandardName value
     * @return \StructType\CharacterString_PropertyType|null
     */
    public function getMetadataStandardName()
    {
        return $this->metadataStandardName;
    }
    /**
     * Set metadataStandardName value
     * @param \StructType\CharacterString_PropertyType $metadataStandardName
     * @return \StructType\MD_Metadata_Type
     */
    public function setMetadataStandardName(\StructType\CharacterString_PropertyType $metadataStandardName = null)
    {
        $this->metadataStandardName = $metadataStandardName;
        return $this;
    }
    /**
     * Get metadataStandardVersion value
     * @return \StructType\CharacterString_PropertyType|null
     */
    public function getMetadataStandardVersion()
    {
        return $this->metadataStandardVersion;
    }
    /**
     * Set metadataStandardVersion value
     * @param \StructType\CharacterString_PropertyType $metadataStandardVersion
     * @return \StructType\MD_Metadata_Type
     */
    public function setMetadataStandardVersion(\StructType\CharacterString_PropertyType $metadataStandardVersion = null)
    {
        $this->metadataStandardVersion = $metadataStandardVersion;
        return $this;
    }
    /**
     * Get dataSetURI value
     * @return \StructType\CharacterString_PropertyType|null
     */
    public function getDataSetURI()
    {
        return $this->dataSetURI;
    }
    /**
     * Set dataSetURI value
     * @param \StructType\CharacterString_PropertyType $dataSetURI
     * @return \StructType\MD_Metadata_Type
     */
    public function setDataSetURI(\StructType\CharacterString_PropertyType $dataSetURI = null)
    {
        $this->dataSetURI = $dataSetURI;
        return $this;
    }
    /**
     * Get locale value
     * @return \StructType\PT_Locale_PropertyType|null
     */
    public function getLocale()
    {
        return $this->locale;
    }
    /**
     * Set locale value
     * @param \StructType\PT_Locale_PropertyType $locale
     * @return \StructType\MD_Metadata_Type
     */
    public function setLocale(\StructType\PT_Locale_PropertyType $locale = null)
    {
        $this->locale = $locale;
        return $this;
    }
    /**
     * Get spatialRepresentationInfo value
     * @return \StructType\MD_SpatialRepresentation_PropertyType|null
     */
    public function getSpatialRepresentationInfo()
    {
        return $this->spatialRepresentationInfo;
    }
    /**
     * Set spatialRepresentationInfo value
     * @param \StructType\MD_SpatialRepresentation_PropertyType $spatialRepresentationInfo
     * @return \StructType\MD_Metadata_Type
     */
    public function setSpatialRepresentationInfo(\StructType\MD_SpatialRepresentation_PropertyType $spatialRepresentationInfo = null)
    {
        $this->spatialRepresentationInfo = $spatialRepresentationInfo;
        return $this;
    }
    /**
     * Get referenceSystemInfo value
     * @return \StructType\MD_ReferenceSystem_PropertyType|null
     */
    public function getReferenceSystemInfo()
    {
        return $this->referenceSystemInfo;
    }
    /**
     * Set referenceSystemInfo value
     * @param \StructType\MD_ReferenceSystem_PropertyType $referenceSystemInfo
     * @return \StructType\MD_Metadata_Type
     */
    public function setReferenceSystemInfo(\StructType\MD_ReferenceSystem_PropertyType $referenceSystemInfo = null)
    {
        $this->referenceSystemInfo = $referenceSystemInfo;
        return $this;
    }
    /**
     * Get metadataExtensionInfo value
     * @return \StructType\MD_MetadataExtensionInformation_PropertyType|null
     */
    public function getMetadataExtensionInfo()
    {
        return $this->metadataExtensionInfo;
    }
    /**
     * Set metadataExtensionInfo value
     * @param \StructType\MD_MetadataExtensionInformation_PropertyType $metadataExtensionInfo
     * @return \StructType\MD_Metadata_Type
     */
    public function setMetadataExtensionInfo(\StructType\MD_MetadataExtensionInformation_PropertyType $metadataExtensionInfo = null)
    {
        $this->metadataExtensionInfo = $metadataExtensionInfo;
        return $this;
    }
    /**
     * Get identificationInfo value
     * @return \StructType\MD_Identification_PropertyType|null
     */
    public function getIdentificationInfo()
    {
        return $this->identificationInfo;
    }
    /**
     * Set identificationInfo value
     * @param \StructType\MD_Identification_PropertyType $identificationInfo
     * @return \StructType\MD_Metadata_Type
     */
    public function setIdentificationInfo(\StructType\MD_Identification_PropertyType $identificationInfo = null)
    {
        $this->identificationInfo = $identificationInfo;
        return $this;
    }
    /**
     * Get contentInfo value
     * @return \StructType\MD_ContentInformation_PropertyType|null
     */
    public function getContentInfo()
    {
        return $this->contentInfo;
    }
    /**
     * Set contentInfo value
     * @param \StructType\MD_ContentInformation_PropertyType $contentInfo
     * @return \StructType\MD_Metadata_Type
     */
    public function setContentInfo(\StructType\MD_ContentInformation_PropertyType $contentInfo = null)
    {
        $this->contentInfo = $contentInfo;
        return $this;
    }
    /**
     * Get distributionInfo value
     * @return \StructType\MD_Distribution_PropertyType|null
     */
    public function getDistributionInfo()
    {
        return $this->distributionInfo;
    }
    /**
     * Set distributionInfo value
     * @param \StructType\MD_Distribution_PropertyType $distributionInfo
     * @return \StructType\MD_Metadata_Type
     */
    public function setDistributionInfo(\StructType\MD_Distribution_PropertyType $distributionInfo = null)
    {
        $this->distributionInfo = $distributionInfo;
        return $this;
    }
    /**
     * Get dataQualityInfo value
     * @return \StructType\DQ_DataQuality_PropertyType|null
     */
    public function getDataQualityInfo()
    {
        return $this->dataQualityInfo;
    }
    /**
     * Set dataQualityInfo value
     * @param \StructType\DQ_DataQuality_PropertyType $dataQualityInfo
     * @return \StructType\MD_Metadata_Type
     */
    public function setDataQualityInfo(\StructType\DQ_DataQuality_PropertyType $dataQualityInfo = null)
    {
        $this->dataQualityInfo = $dataQualityInfo;
        return $this;
    }
    /**
     * Get portrayalCatalogueInfo value
     * @return \StructType\MD_PortrayalCatalogueReference_PropertyType|null
     */
    public function getPortrayalCatalogueInfo()
    {
        return $this->portrayalCatalogueInfo;
    }
    /**
     * Set portrayalCatalogueInfo value
     * @param \StructType\MD_PortrayalCatalogueReference_PropertyType $portrayalCatalogueInfo
     * @return \StructType\MD_Metadata_Type
     */
    public function setPortrayalCatalogueInfo(\StructType\MD_PortrayalCatalogueReference_PropertyType $portrayalCatalogueInfo = null)
    {
        $this->portrayalCatalogueInfo = $portrayalCatalogueInfo;
        return $this;
    }
    /**
     * Get metadataConstraints value
     * @return \StructType\MD_Constraints_PropertyType|null
     */
    public function getMetadataConstraints()
    {
        return $this->metadataConstraints;
    }
    /**
     * Set metadataConstraints value
     * @param \StructType\MD_Constraints_PropertyType $metadataConstraints
     * @return \StructType\MD_Metadata_Type
     */
    public function setMetadataConstraints(\StructType\MD_Constraints_PropertyType $metadataConstraints = null)
    {
        $this->metadataConstraints = $metadataConstraints;
        return $this;
    }
    /**
     * Get applicationSchemaInfo value
     * @return \StructType\MD_ApplicationSchemaInformation_PropertyType|null
     */
    public function getApplicationSchemaInfo()
    {
        return $this->applicationSchemaInfo;
    }
    /**
     * Set applicationSchemaInfo value
     * @param \StructType\MD_ApplicationSchemaInformation_PropertyType $applicationSchemaInfo
     * @return \StructType\MD_Metadata_Type
     */
    public function setApplicationSchemaInfo(\StructType\MD_ApplicationSchemaInformation_PropertyType $applicationSchemaInfo = null)
    {
        $this->applicationSchemaInfo = $applicationSchemaInfo;
        return $this;
    }
    /**
     * Get metadataMaintenance value
     * @return \StructType\MD_MaintenanceInformation_PropertyType|null
     */
    public function getMetadataMaintenance()
    {
        return $this->metadataMaintenance;
    }
    /**
     * Set metadataMaintenance value
     * @param \StructType\MD_MaintenanceInformation_PropertyType $metadataMaintenance
     * @return \StructType\MD_Metadata_Type
     */
    public function setMetadataMaintenance(\StructType\MD_MaintenanceInformation_PropertyType $metadataMaintenance = null)
    {
        $this->metadataMaintenance = $metadataMaintenance;
        return $this;
    }
    /**
     * Get series value
     * @return \StructType\DS_Aggregate_PropertyType|null
     */
    public function getSeries()
    {
        return $this->series;
    }
    /**
     * Set series value
     * @param \StructType\DS_Aggregate_PropertyType $series
     * @return \StructType\MD_Metadata_Type
     */
    public function setSeries(\StructType\DS_Aggregate_PropertyType $series = null)
    {
        $this->series = $series;
        return $this;
    }
    /**
     * Get describes value
     * @return \StructType\DS_DataSet_PropertyType|null
     */
    public function getDescribes()
    {
        return $this->describes;
    }
    /**
     * Set describes value
     * @param \StructType\DS_DataSet_PropertyType $describes
     * @return \StructType\MD_Metadata_Type
     */
    public function setDescribes(\StructType\DS_DataSet_PropertyType $describes = null)
    {
        $this->describes = $describes;
        return $this;
    }
    /**
     * Get propertyType value
     * @return \StructType\ObjectReference_PropertyType|null
     */
    public function getPropertyType()
    {
        return $this->propertyType;
    }
    /**
     * Set propertyType value
     * @param \StructType\ObjectReference_PropertyType $propertyType
     * @return \StructType\MD_Metadata_Type
     */
    public function setPropertyType(\StructType\ObjectReference_PropertyType $propertyType = null)
    {
        $this->propertyType = $propertyType;
        return $this;
    }
    /**
     * Get featureType value
     * @return \StructType\ObjectReference_PropertyType|null
     */
    public function getFeatureType()
    {
        return $this->featureType;
    }
    /**
     * Set featureType value
     * @param \StructType\ObjectReference_PropertyType $featureType
     * @return \StructType\MD_Metadata_Type
     */
    public function setFeatureType(\StructType\ObjectReference_PropertyType $featureType = null)
    {
        $this->featureType = $featureType;
        return $this;
    }
    /**
     * Get featureAttribute value
     * @return \StructType\ObjectReference_PropertyType|null
     */
    public function getFeatureAttribute()
    {
        return $this->featureAttribute;
    }
    /**
     * Set featureAttribute value
     * @param \StructType\ObjectReference_PropertyType $featureAttribute
     * @return \StructType\MD_Metadata_Type
     */
    public function setFeatureAttribute(\StructType\ObjectReference_PropertyType $featureAttribute = null)
    {
        $this->featureAttribute = $featureAttribute;
        return $this;
    }
}
