<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MD_Medium_Type StructType
 * @subpackage Structs
 */
class MD_Medium_Type extends AbstractStructBase
{
    /**
     * The name
     * @var \StructType\MD_MediumNameCode_PropertyType
     */
    public $name;
    /**
     * The density
     * @var \StructType\Real_PropertyType
     */
    public $density;
    /**
     * The densityUnits
     * @var \StructType\CharacterString_PropertyType
     */
    public $densityUnits;
    /**
     * The volumes
     * @var \StructType\Integer_PropertyType
     */
    public $volumes;
    /**
     * The mediumFormat
     * @var \StructType\MD_MediumFormatCode_PropertyType
     */
    public $mediumFormat;
    /**
     * The mediumNote
     * @var \StructType\CharacterString_PropertyType
     */
    public $mediumNote;
    /**
     * Constructor method for MD_Medium_Type
     * @uses MD_Medium_Type::setName()
     * @uses MD_Medium_Type::setDensity()
     * @uses MD_Medium_Type::setDensityUnits()
     * @uses MD_Medium_Type::setVolumes()
     * @uses MD_Medium_Type::setMediumFormat()
     * @uses MD_Medium_Type::setMediumNote()
     * @param \StructType\MD_MediumNameCode_PropertyType $name
     * @param \StructType\Real_PropertyType $density
     * @param \StructType\CharacterString_PropertyType $densityUnits
     * @param \StructType\Integer_PropertyType $volumes
     * @param \StructType\MD_MediumFormatCode_PropertyType $mediumFormat
     * @param \StructType\CharacterString_PropertyType $mediumNote
     */
    public function __construct(\StructType\MD_MediumNameCode_PropertyType $name = null, \StructType\Real_PropertyType $density = null, \StructType\CharacterString_PropertyType $densityUnits = null, \StructType\Integer_PropertyType $volumes = null, \StructType\MD_MediumFormatCode_PropertyType $mediumFormat = null, \StructType\CharacterString_PropertyType $mediumNote = null)
    {
        $this
            ->setName($name)
            ->setDensity($density)
            ->setDensityUnits($densityUnits)
            ->setVolumes($volumes)
            ->setMediumFormat($mediumFormat)
            ->setMediumNote($mediumNote);
    }
    /**
     * Get name value
     * @return \StructType\MD_MediumNameCode_PropertyType|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param \StructType\MD_MediumNameCode_PropertyType $name
     * @return \StructType\MD_Medium_Type
     */
    public function setName(\StructType\MD_MediumNameCode_PropertyType $name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get density value
     * @return \StructType\Real_PropertyType|null
     */
    public function getDensity()
    {
        return $this->density;
    }
    /**
     * Set density value
     * @param \StructType\Real_PropertyType $density
     * @return \StructType\MD_Medium_Type
     */
    public function setDensity(\StructType\Real_PropertyType $density = null)
    {
        $this->density = $density;
        return $this;
    }
    /**
     * Get densityUnits value
     * @return \StructType\CharacterString_PropertyType|null
     */
    public function getDensityUnits()
    {
        return $this->densityUnits;
    }
    /**
     * Set densityUnits value
     * @param \StructType\CharacterString_PropertyType $densityUnits
     * @return \StructType\MD_Medium_Type
     */
    public function setDensityUnits(\StructType\CharacterString_PropertyType $densityUnits = null)
    {
        $this->densityUnits = $densityUnits;
        return $this;
    }
    /**
     * Get volumes value
     * @return \StructType\Integer_PropertyType|null
     */
    public function getVolumes()
    {
        return $this->volumes;
    }
    /**
     * Set volumes value
     * @param \StructType\Integer_PropertyType $volumes
     * @return \StructType\MD_Medium_Type
     */
    public function setVolumes(\StructType\Integer_PropertyType $volumes = null)
    {
        $this->volumes = $volumes;
        return $this;
    }
    /**
     * Get mediumFormat value
     * @return \StructType\MD_MediumFormatCode_PropertyType|null
     */
    public function getMediumFormat()
    {
        return $this->mediumFormat;
    }
    /**
     * Set mediumFormat value
     * @param \StructType\MD_MediumFormatCode_PropertyType $mediumFormat
     * @return \StructType\MD_Medium_Type
     */
    public function setMediumFormat(\StructType\MD_MediumFormatCode_PropertyType $mediumFormat = null)
    {
        $this->mediumFormat = $mediumFormat;
        return $this;
    }
    /**
     * Get mediumNote value
     * @return \StructType\CharacterString_PropertyType|null
     */
    public function getMediumNote()
    {
        return $this->mediumNote;
    }
    /**
     * Set mediumNote value
     * @param \StructType\CharacterString_PropertyType $mediumNote
     * @return \StructType\MD_Medium_Type
     */
    public function setMediumNote(\StructType\CharacterString_PropertyType $mediumNote = null)
    {
        $this->mediumNote = $mediumNote;
        return $this;
    }
}
