<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MD_Distribution_Type StructType
 * @subpackage Structs
 */
class MD_Distribution_Type extends AbstractStructBase
{
    /**
     * The distributionFormat
     * @var \StructType\MD_Format_PropertyType
     */
    public $distributionFormat;
    /**
     * The distributor
     * @var \StructType\MD_Distributor_PropertyType
     */
    public $distributor;
    /**
     * The transferOptions
     * @var \StructType\MD_DigitalTransferOptions_PropertyType
     */
    public $transferOptions;
    /**
     * Constructor method for MD_Distribution_Type
     * @uses MD_Distribution_Type::setDistributionFormat()
     * @uses MD_Distribution_Type::setDistributor()
     * @uses MD_Distribution_Type::setTransferOptions()
     * @param \StructType\MD_Format_PropertyType $distributionFormat
     * @param \StructType\MD_Distributor_PropertyType $distributor
     * @param \StructType\MD_DigitalTransferOptions_PropertyType $transferOptions
     */
    public function __construct(\StructType\MD_Format_PropertyType $distributionFormat = null, \StructType\MD_Distributor_PropertyType $distributor = null, \StructType\MD_DigitalTransferOptions_PropertyType $transferOptions = null)
    {
        $this
            ->setDistributionFormat($distributionFormat)
            ->setDistributor($distributor)
            ->setTransferOptions($transferOptions);
    }
    /**
     * Get distributionFormat value
     * @return \StructType\MD_Format_PropertyType|null
     */
    public function getDistributionFormat()
    {
        return $this->distributionFormat;
    }
    /**
     * Set distributionFormat value
     * @param \StructType\MD_Format_PropertyType $distributionFormat
     * @return \StructType\MD_Distribution_Type
     */
    public function setDistributionFormat(\StructType\MD_Format_PropertyType $distributionFormat = null)
    {
        $this->distributionFormat = $distributionFormat;
        return $this;
    }
    /**
     * Get distributor value
     * @return \StructType\MD_Distributor_PropertyType|null
     */
    public function getDistributor()
    {
        return $this->distributor;
    }
    /**
     * Set distributor value
     * @param \StructType\MD_Distributor_PropertyType $distributor
     * @return \StructType\MD_Distribution_Type
     */
    public function setDistributor(\StructType\MD_Distributor_PropertyType $distributor = null)
    {
        $this->distributor = $distributor;
        return $this;
    }
    /**
     * Get transferOptions value
     * @return \StructType\MD_DigitalTransferOptions_PropertyType|null
     */
    public function getTransferOptions()
    {
        return $this->transferOptions;
    }
    /**
     * Set transferOptions value
     * @param \StructType\MD_DigitalTransferOptions_PropertyType $transferOptions
     * @return \StructType\MD_Distribution_Type
     */
    public function setTransferOptions(\StructType\MD_DigitalTransferOptions_PropertyType $transferOptions = null)
    {
        $this->transferOptions = $transferOptions;
        return $this;
    }
}
