<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LineStringSegmentType StructType
 * @subpackage Structs
 */
class LineStringSegmentType extends AbstractStructBase
{
    /**
     * The pos
     * @var \StructType\DirectPositionType
     */
    public $pos;
    /**
     * The pointProperty
     * @var \StructType\PointPropertyType
     */
    public $pointProperty;
    /**
     * The pointRep
     * @var \StructType\PointPropertyType
     */
    public $pointRep;
    /**
     * The posList
     * @var \StructType\DirectPositionListType
     */
    public $posList;
    /**
     * The coordinates
     * @var \StructType\CoordinatesType
     */
    public $coordinates;
    /**
     * The interpolation
     * @var string
     */
    public $interpolation;
    /**
     * Constructor method for LineStringSegmentType
     * @uses LineStringSegmentType::setPos()
     * @uses LineStringSegmentType::setPointProperty()
     * @uses LineStringSegmentType::setPointRep()
     * @uses LineStringSegmentType::setPosList()
     * @uses LineStringSegmentType::setCoordinates()
     * @uses LineStringSegmentType::setInterpolation()
     * @param \StructType\DirectPositionType $pos
     * @param \StructType\PointPropertyType $pointProperty
     * @param \StructType\PointPropertyType $pointRep
     * @param \StructType\DirectPositionListType $posList
     * @param \StructType\CoordinatesType $coordinates
     * @param string $interpolation
     */
    public function __construct(\StructType\DirectPositionType $pos = null, \StructType\PointPropertyType $pointProperty = null, \StructType\PointPropertyType $pointRep = null, \StructType\DirectPositionListType $posList = null, \StructType\CoordinatesType $coordinates = null, $interpolation = null)
    {
        $this
            ->setPos($pos)
            ->setPointProperty($pointProperty)
            ->setPointRep($pointRep)
            ->setPosList($posList)
            ->setCoordinates($coordinates)
            ->setInterpolation($interpolation);
    }
    /**
     * Get pos value
     * @return \StructType\DirectPositionType|null
     */
    public function getPos()
    {
        return $this->pos;
    }
    /**
     * Set pos value
     * @param \StructType\DirectPositionType $pos
     * @return \StructType\LineStringSegmentType
     */
    public function setPos(\StructType\DirectPositionType $pos = null)
    {
        $this->pos = $pos;
        return $this;
    }
    /**
     * Get pointProperty value
     * @return \StructType\PointPropertyType|null
     */
    public function getPointProperty()
    {
        return $this->pointProperty;
    }
    /**
     * Set pointProperty value
     * @param \StructType\PointPropertyType $pointProperty
     * @return \StructType\LineStringSegmentType
     */
    public function setPointProperty(\StructType\PointPropertyType $pointProperty = null)
    {
        $this->pointProperty = $pointProperty;
        return $this;
    }
    /**
     * Get pointRep value
     * @return \StructType\PointPropertyType|null
     */
    public function getPointRep()
    {
        return $this->pointRep;
    }
    /**
     * Set pointRep value
     * @param \StructType\PointPropertyType $pointRep
     * @return \StructType\LineStringSegmentType
     */
    public function setPointRep(\StructType\PointPropertyType $pointRep = null)
    {
        $this->pointRep = $pointRep;
        return $this;
    }
    /**
     * Get posList value
     * @return \StructType\DirectPositionListType|null
     */
    public function getPosList()
    {
        return $this->posList;
    }
    /**
     * Set posList value
     * @param \StructType\DirectPositionListType $posList
     * @return \StructType\LineStringSegmentType
     */
    public function setPosList(\StructType\DirectPositionListType $posList = null)
    {
        $this->posList = $posList;
        return $this;
    }
    /**
     * Get coordinates value
     * @return \StructType\CoordinatesType|null
     */
    public function getCoordinates()
    {
        return $this->coordinates;
    }
    /**
     * Set coordinates value
     * @param \StructType\CoordinatesType $coordinates
     * @return \StructType\LineStringSegmentType
     */
    public function setCoordinates(\StructType\CoordinatesType $coordinates = null)
    {
        $this->coordinates = $coordinates;
        return $this;
    }
    /**
     * Get interpolation value
     * @return string|null
     */
    public function getInterpolation()
    {
        return $this->interpolation;
    }
    /**
     * Set interpolation value
     * @param string $interpolation
     * @return \StructType\LineStringSegmentType
     */
    public function setInterpolation($interpolation = null)
    {
        // validation for constraint: string
        if (!is_null($interpolation) && !is_string($interpolation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($interpolation, true), gettype($interpolation)), __LINE__);
        }
        $this->interpolation = $interpolation;
        return $this;
    }
}
