<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LeistungSpezialisierung StructType
 * Meta information extracted from the WSDL
 * - documentation: Eine Leistungsspezialisierung ist das Hinzufügen, Entfernen oder Ersetzen von Leistungsmodulen für verschiedene Ebenen in der Verwaltungshierarchie. Alle gleichen Spezialsierungsinhalte pro Gebietsfächer sollen in einem
 * LeistungSpezialisierung-Objekt zusammengefasst werden.
 * @subpackage Structs
 */
class LeistungSpezialisierung extends AbstractStructBase
{
    /**
     * The idLeistung
     * Meta information extracted from the WSDL
     * - documentation: ID der Leistung, welche spezialisiert werden soll.
     * @var \StructType\Identifikator
     */
    public $idLeistung;
    /**
     * The idGebiet
     * Meta information extracted from the WSDL
     * - documentation: Gibt an, für welche Gebiete die Leistung spezialisiert ist.
     * - maxOccurs: unbounded
     * @var \StructType\Identifikator[]
     */
    public $idGebiet;
    /**
     * The bezeichnung
     * Meta information extracted from the WSDL
     * - documentation: Optionale Bezeichnung bzw. Überschrift der Spezialisierung, z.B. "Spezielle Hinweise für Landkreis Mansfeld-Südharz".
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\String_Localized[]
     */
    public $bezeichnung;
    /**
     * The modulSpezialisiert
     * Meta information extracted from the WSDL
     * - documentation: Angabe aller Module einer Leistung, welche die übergeordnete Leistung spezialisieren. Es können neue Module hinzugefügt oder bestehende ergänzt oder ersetzt werden.
     * - maxOccurs: unbounded
     * @var \StructType\LeistungsmodulSpezialisierung[]
     */
    public $modulSpezialisiert;
    /**
     * The id
     * Meta information extracted from the WSDL
     * - documentation: Optionale Primäre ID der Leistungsspezialisierung.
     * - minOccurs: 0
     * @var \StructType\Identifikator
     */
    public $id;
    /**
     * The idSekundaer
     * Meta information extracted from the WSDL
     * - documentation: Sekundäre IDs der Leistungspsezialisierung.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Identifikator[]
     */
    public $idSekundaer;
    /**
     * Constructor method for LeistungSpezialisierung
     * @uses LeistungSpezialisierung::setIdLeistung()
     * @uses LeistungSpezialisierung::setIdGebiet()
     * @uses LeistungSpezialisierung::setBezeichnung()
     * @uses LeistungSpezialisierung::setModulSpezialisiert()
     * @uses LeistungSpezialisierung::setId()
     * @uses LeistungSpezialisierung::setIdSekundaer()
     * @param \StructType\Identifikator $idLeistung
     * @param \StructType\Identifikator[] $idGebiet
     * @param \StructType\String_Localized[] $bezeichnung
     * @param \StructType\LeistungsmodulSpezialisierung[] $modulSpezialisiert
     * @param \StructType\Identifikator $id
     * @param \StructType\Identifikator[] $idSekundaer
     */
    public function __construct(\StructType\Identifikator $idLeistung = null, array $idGebiet = array(), array $bezeichnung = array(), array $modulSpezialisiert = array(), \StructType\Identifikator $id = null, array $idSekundaer = array())
    {
        $this
            ->setIdLeistung($idLeistung)
            ->setIdGebiet($idGebiet)
            ->setBezeichnung($bezeichnung)
            ->setModulSpezialisiert($modulSpezialisiert)
            ->setId($id)
            ->setIdSekundaer($idSekundaer);
    }
    /**
     * Get idLeistung value
     * @return \StructType\Identifikator|null
     */
    public function getIdLeistung()
    {
        return $this->idLeistung;
    }
    /**
     * Set idLeistung value
     * @param \StructType\Identifikator $idLeistung
     * @return \StructType\LeistungSpezialisierung
     */
    public function setIdLeistung(\StructType\Identifikator $idLeistung = null)
    {
        $this->idLeistung = $idLeistung;
        return $this;
    }
    /**
     * Get idGebiet value
     * @return \StructType\Identifikator[]|null
     */
    public function getIdGebiet()
    {
        return $this->idGebiet;
    }
    /**
     * This method is responsible for validating the values passed to the setIdGebiet method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIdGebiet method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIdGebietForArrayConstraintsFromSetIdGebiet(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $leistungSpezialisierungIdGebietItem) {
            // validation for constraint: itemType
            if (!$leistungSpezialisierungIdGebietItem instanceof \StructType\Identifikator) {
                $invalidValues[] = is_object($leistungSpezialisierungIdGebietItem) ? get_class($leistungSpezialisierungIdGebietItem) : sprintf('%s(%s)', gettype($leistungSpezialisierungIdGebietItem), var_export($leistungSpezialisierungIdGebietItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The idGebiet property can only contain items of type \StructType\Identifikator, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set idGebiet value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator[] $idGebiet
     * @return \StructType\LeistungSpezialisierung
     */
    public function setIdGebiet(array $idGebiet = array())
    {
        // validation for constraint: array
        if ('' !== ($idGebietArrayErrorMessage = self::validateIdGebietForArrayConstraintsFromSetIdGebiet($idGebiet))) {
            throw new \InvalidArgumentException($idGebietArrayErrorMessage, __LINE__);
        }
        $this->idGebiet = $idGebiet;
        return $this;
    }
    /**
     * Add item to idGebiet value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator $item
     * @return \StructType\LeistungSpezialisierung
     */
    public function addToIdGebiet(\StructType\Identifikator $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Identifikator) {
            throw new \InvalidArgumentException(sprintf('The idGebiet property can only contain items of type \StructType\Identifikator, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->idGebiet[] = $item;
        return $this;
    }
    /**
     * Get bezeichnung value
     * @return \StructType\String_Localized[]|null
     */
    public function getBezeichnung()
    {
        return $this->bezeichnung;
    }
    /**
     * This method is responsible for validating the values passed to the setBezeichnung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBezeichnung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBezeichnungForArrayConstraintsFromSetBezeichnung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $leistungSpezialisierungBezeichnungItem) {
            // validation for constraint: itemType
            if (!$leistungSpezialisierungBezeichnungItem instanceof \StructType\String_Localized) {
                $invalidValues[] = is_object($leistungSpezialisierungBezeichnungItem) ? get_class($leistungSpezialisierungBezeichnungItem) : sprintf('%s(%s)', gettype($leistungSpezialisierungBezeichnungItem), var_export($leistungSpezialisierungBezeichnungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The bezeichnung property can only contain items of type \StructType\String_Localized, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set bezeichnung value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized[] $bezeichnung
     * @return \StructType\LeistungSpezialisierung
     */
    public function setBezeichnung(array $bezeichnung = array())
    {
        // validation for constraint: array
        if ('' !== ($bezeichnungArrayErrorMessage = self::validateBezeichnungForArrayConstraintsFromSetBezeichnung($bezeichnung))) {
            throw new \InvalidArgumentException($bezeichnungArrayErrorMessage, __LINE__);
        }
        $this->bezeichnung = $bezeichnung;
        return $this;
    }
    /**
     * Add item to bezeichnung value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized $item
     * @return \StructType\LeistungSpezialisierung
     */
    public function addToBezeichnung(\StructType\String_Localized $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\String_Localized) {
            throw new \InvalidArgumentException(sprintf('The bezeichnung property can only contain items of type \StructType\String_Localized, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->bezeichnung[] = $item;
        return $this;
    }
    /**
     * Get modulSpezialisiert value
     * @return \StructType\LeistungsmodulSpezialisierung[]|null
     */
    public function getModulSpezialisiert()
    {
        return $this->modulSpezialisiert;
    }
    /**
     * This method is responsible for validating the values passed to the setModulSpezialisiert method
     * This method is willingly generated in order to preserve the one-line inline validation within the setModulSpezialisiert method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateModulSpezialisiertForArrayConstraintsFromSetModulSpezialisiert(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $leistungSpezialisierungModulSpezialisiertItem) {
            // validation for constraint: itemType
            if (!$leistungSpezialisierungModulSpezialisiertItem instanceof \StructType\LeistungsmodulSpezialisierung) {
                $invalidValues[] = is_object($leistungSpezialisierungModulSpezialisiertItem) ? get_class($leistungSpezialisierungModulSpezialisiertItem) : sprintf('%s(%s)', gettype($leistungSpezialisierungModulSpezialisiertItem), var_export($leistungSpezialisierungModulSpezialisiertItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The modulSpezialisiert property can only contain items of type \StructType\LeistungsmodulSpezialisierung, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set modulSpezialisiert value
     * @throws \InvalidArgumentException
     * @param \StructType\LeistungsmodulSpezialisierung[] $modulSpezialisiert
     * @return \StructType\LeistungSpezialisierung
     */
    public function setModulSpezialisiert(array $modulSpezialisiert = array())
    {
        // validation for constraint: array
        if ('' !== ($modulSpezialisiertArrayErrorMessage = self::validateModulSpezialisiertForArrayConstraintsFromSetModulSpezialisiert($modulSpezialisiert))) {
            throw new \InvalidArgumentException($modulSpezialisiertArrayErrorMessage, __LINE__);
        }
        $this->modulSpezialisiert = $modulSpezialisiert;
        return $this;
    }
    /**
     * Add item to modulSpezialisiert value
     * @throws \InvalidArgumentException
     * @param \StructType\LeistungsmodulSpezialisierung $item
     * @return \StructType\LeistungSpezialisierung
     */
    public function addToModulSpezialisiert(\StructType\LeistungsmodulSpezialisierung $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LeistungsmodulSpezialisierung) {
            throw new \InvalidArgumentException(sprintf('The modulSpezialisiert property can only contain items of type \StructType\LeistungsmodulSpezialisierung, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->modulSpezialisiert[] = $item;
        return $this;
    }
    /**
     * Get id value
     * @return \StructType\Identifikator|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param \StructType\Identifikator $id
     * @return \StructType\LeistungSpezialisierung
     */
    public function setId(\StructType\Identifikator $id = null)
    {
        $this->id = $id;
        return $this;
    }
    /**
     * Get idSekundaer value
     * @return \StructType\Identifikator[]|null
     */
    public function getIdSekundaer()
    {
        return $this->idSekundaer;
    }
    /**
     * This method is responsible for validating the values passed to the setIdSekundaer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIdSekundaer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIdSekundaerForArrayConstraintsFromSetIdSekundaer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $leistungSpezialisierungIdSekundaerItem) {
            // validation for constraint: itemType
            if (!$leistungSpezialisierungIdSekundaerItem instanceof \StructType\Identifikator) {
                $invalidValues[] = is_object($leistungSpezialisierungIdSekundaerItem) ? get_class($leistungSpezialisierungIdSekundaerItem) : sprintf('%s(%s)', gettype($leistungSpezialisierungIdSekundaerItem), var_export($leistungSpezialisierungIdSekundaerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The idSekundaer property can only contain items of type \StructType\Identifikator, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set idSekundaer value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator[] $idSekundaer
     * @return \StructType\LeistungSpezialisierung
     */
    public function setIdSekundaer(array $idSekundaer = array())
    {
        // validation for constraint: array
        if ('' !== ($idSekundaerArrayErrorMessage = self::validateIdSekundaerForArrayConstraintsFromSetIdSekundaer($idSekundaer))) {
            throw new \InvalidArgumentException($idSekundaerArrayErrorMessage, __LINE__);
        }
        $this->idSekundaer = $idSekundaer;
        return $this;
    }
    /**
     * Add item to idSekundaer value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator $item
     * @return \StructType\LeistungSpezialisierung
     */
    public function addToIdSekundaer(\StructType\Identifikator $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Identifikator) {
            throw new \InvalidArgumentException(sprintf('The idSekundaer property can only contain items of type \StructType\Identifikator, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->idSekundaer[] = $item;
        return $this;
    }
}
