<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KontaktpersonTransferobjekt StructType
 * Meta information extracted from the WSDL
 * - documentation: Spezielles Transferobjekt für Personen. Dieses kann die ID der Organisationseinheiten beinhalten.
 * @subpackage Structs
 */
class KontaktpersonTransferobjekt extends AbstractStructBase
{
    /**
     * The organisationseinheitID
     * Meta information extracted from the WSDL
     * - documentation: ID der übergeordneten Objekt(e), d.h. die IDs der Organisationseinheiten, welchen die Person zugeordnet ist.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Identifikator[]
     */
    public $organisationseinheitID;
    /**
     * The kontaktperson
     * Meta information extracted from the WSDL
     * - documentation: Die Kontaktperson(en).
     * - maxOccurs: unbounded
     * @var \StructType\Kontaktperson[]
     */
    public $kontaktperson;
    /**
     * Constructor method for KontaktpersonTransferobjekt
     * @uses KontaktpersonTransferobjekt::setOrganisationseinheitID()
     * @uses KontaktpersonTransferobjekt::setKontaktperson()
     * @param \StructType\Identifikator[] $organisationseinheitID
     * @param \StructType\Kontaktperson[] $kontaktperson
     */
    public function __construct(array $organisationseinheitID = array(), array $kontaktperson = array())
    {
        $this
            ->setOrganisationseinheitID($organisationseinheitID)
            ->setKontaktperson($kontaktperson);
    }
    /**
     * Get organisationseinheitID value
     * @return \StructType\Identifikator[]|null
     */
    public function getOrganisationseinheitID()
    {
        return $this->organisationseinheitID;
    }
    /**
     * This method is responsible for validating the values passed to the setOrganisationseinheitID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrganisationseinheitID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrganisationseinheitIDForArrayConstraintsFromSetOrganisationseinheitID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kontaktpersonTransferobjektOrganisationseinheitIDItem) {
            // validation for constraint: itemType
            if (!$kontaktpersonTransferobjektOrganisationseinheitIDItem instanceof \StructType\Identifikator) {
                $invalidValues[] = is_object($kontaktpersonTransferobjektOrganisationseinheitIDItem) ? get_class($kontaktpersonTransferobjektOrganisationseinheitIDItem) : sprintf('%s(%s)', gettype($kontaktpersonTransferobjektOrganisationseinheitIDItem), var_export($kontaktpersonTransferobjektOrganisationseinheitIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The organisationseinheitID property can only contain items of type \StructType\Identifikator, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set organisationseinheitID value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator[] $organisationseinheitID
     * @return \StructType\KontaktpersonTransferobjekt
     */
    public function setOrganisationseinheitID(array $organisationseinheitID = array())
    {
        // validation for constraint: array
        if ('' !== ($organisationseinheitIDArrayErrorMessage = self::validateOrganisationseinheitIDForArrayConstraintsFromSetOrganisationseinheitID($organisationseinheitID))) {
            throw new \InvalidArgumentException($organisationseinheitIDArrayErrorMessage, __LINE__);
        }
        $this->organisationseinheitID = $organisationseinheitID;
        return $this;
    }
    /**
     * Add item to organisationseinheitID value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator $item
     * @return \StructType\KontaktpersonTransferobjekt
     */
    public function addToOrganisationseinheitID(\StructType\Identifikator $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Identifikator) {
            throw new \InvalidArgumentException(sprintf('The organisationseinheitID property can only contain items of type \StructType\Identifikator, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->organisationseinheitID[] = $item;
        return $this;
    }
    /**
     * Get kontaktperson value
     * @return \StructType\Kontaktperson[]|null
     */
    public function getKontaktperson()
    {
        return $this->kontaktperson;
    }
    /**
     * This method is responsible for validating the values passed to the setKontaktperson method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKontaktperson method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKontaktpersonForArrayConstraintsFromSetKontaktperson(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kontaktpersonTransferobjektKontaktpersonItem) {
            // validation for constraint: itemType
            if (!$kontaktpersonTransferobjektKontaktpersonItem instanceof \StructType\Kontaktperson) {
                $invalidValues[] = is_object($kontaktpersonTransferobjektKontaktpersonItem) ? get_class($kontaktpersonTransferobjektKontaktpersonItem) : sprintf('%s(%s)', gettype($kontaktpersonTransferobjektKontaktpersonItem), var_export($kontaktpersonTransferobjektKontaktpersonItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The kontaktperson property can only contain items of type \StructType\Kontaktperson, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set kontaktperson value
     * @throws \InvalidArgumentException
     * @param \StructType\Kontaktperson[] $kontaktperson
     * @return \StructType\KontaktpersonTransferobjekt
     */
    public function setKontaktperson(array $kontaktperson = array())
    {
        // validation for constraint: array
        if ('' !== ($kontaktpersonArrayErrorMessage = self::validateKontaktpersonForArrayConstraintsFromSetKontaktperson($kontaktperson))) {
            throw new \InvalidArgumentException($kontaktpersonArrayErrorMessage, __LINE__);
        }
        $this->kontaktperson = $kontaktperson;
        return $this;
    }
    /**
     * Add item to kontaktperson value
     * @throws \InvalidArgumentException
     * @param \StructType\Kontaktperson $item
     * @return \StructType\KontaktpersonTransferobjekt
     */
    public function addToKontaktperson(\StructType\Kontaktperson $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Kontaktperson) {
            throw new \InvalidArgumentException(sprintf('The kontaktperson property can only contain items of type \StructType\Kontaktperson, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->kontaktperson[] = $item;
        return $this;
    }
}
