<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KontaktpersonErweitert StructType
 * Meta information extracted from the WSDL
 * - documentation: Abgeleitete Klasse von Kontaktperson mit zusätzlicher Angabe der Zuordnung zu Organisationseinheiten.
 * @subpackage Structs
 */
class KontaktpersonErweitert extends Kontaktperson
{
    /**
     * The organisationseinheitID
     * Meta information extracted from the WSDL
     * - documentation: IDs von Organisationseinheiten, denen die Kontaktperson zugeordnet ist.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Identifikator[]
     */
    public $organisationseinheitID;
    /**
     * Constructor method for KontaktpersonErweitert
     * @uses KontaktpersonErweitert::setOrganisationseinheitID()
     * @param \StructType\Identifikator[] $organisationseinheitID
     */
    public function __construct(array $organisationseinheitID = array())
    {
        $this
            ->setOrganisationseinheitID($organisationseinheitID);
    }
    /**
     * Get organisationseinheitID value
     * @return \StructType\Identifikator[]|null
     */
    public function getOrganisationseinheitID()
    {
        return $this->organisationseinheitID;
    }
    /**
     * This method is responsible for validating the values passed to the setOrganisationseinheitID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrganisationseinheitID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrganisationseinheitIDForArrayConstraintsFromSetOrganisationseinheitID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kontaktpersonErweitertOrganisationseinheitIDItem) {
            // validation for constraint: itemType
            if (!$kontaktpersonErweitertOrganisationseinheitIDItem instanceof \StructType\Identifikator) {
                $invalidValues[] = is_object($kontaktpersonErweitertOrganisationseinheitIDItem) ? get_class($kontaktpersonErweitertOrganisationseinheitIDItem) : sprintf('%s(%s)', gettype($kontaktpersonErweitertOrganisationseinheitIDItem), var_export($kontaktpersonErweitertOrganisationseinheitIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The organisationseinheitID property can only contain items of type \StructType\Identifikator, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set organisationseinheitID value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator[] $organisationseinheitID
     * @return \StructType\KontaktpersonErweitert
     */
    public function setOrganisationseinheitID(array $organisationseinheitID = array())
    {
        // validation for constraint: array
        if ('' !== ($organisationseinheitIDArrayErrorMessage = self::validateOrganisationseinheitIDForArrayConstraintsFromSetOrganisationseinheitID($organisationseinheitID))) {
            throw new \InvalidArgumentException($organisationseinheitIDArrayErrorMessage, __LINE__);
        }
        $this->organisationseinheitID = $organisationseinheitID;
        return $this;
    }
    /**
     * Add item to organisationseinheitID value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator $item
     * @return \StructType\KontaktpersonErweitert
     */
    public function addToOrganisationseinheitID(\StructType\Identifikator $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Identifikator) {
            throw new \InvalidArgumentException(sprintf('The organisationseinheitID property can only contain items of type \StructType\Identifikator, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->organisationseinheitID[] = $item;
        return $this;
    }
}
