<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HistoryPropertyType StructType
 * @subpackage Structs
 */
class HistoryPropertyType extends AbstractStructBase
{
    /**
     * The AbstractTimeSlice
     * @var \StructType\AbstractTimeSliceType
     */
    public $AbstractTimeSlice;
    /**
     * The owns
     * @var bool
     */
    public $owns;
    /**
     * Constructor method for HistoryPropertyType
     * @uses HistoryPropertyType::setAbstractTimeSlice()
     * @uses HistoryPropertyType::setOwns()
     * @param \StructType\AbstractTimeSliceType $abstractTimeSlice
     * @param bool $owns
     */
    public function __construct(\StructType\AbstractTimeSliceType $abstractTimeSlice = null, $owns = null)
    {
        $this
            ->setAbstractTimeSlice($abstractTimeSlice)
            ->setOwns($owns);
    }
    /**
     * Get AbstractTimeSlice value
     * @return \StructType\AbstractTimeSliceType|null
     */
    public function getAbstractTimeSlice()
    {
        return $this->AbstractTimeSlice;
    }
    /**
     * Set AbstractTimeSlice value
     * @param \StructType\AbstractTimeSliceType $abstractTimeSlice
     * @return \StructType\HistoryPropertyType
     */
    public function setAbstractTimeSlice(\StructType\AbstractTimeSliceType $abstractTimeSlice = null)
    {
        $this->AbstractTimeSlice = $abstractTimeSlice;
        return $this;
    }
    /**
     * Get owns value
     * @return bool|null
     */
    public function getOwns()
    {
        return $this->owns;
    }
    /**
     * Set owns value
     * @param bool $owns
     * @return \StructType\HistoryPropertyType
     */
    public function setOwns($owns = null)
    {
        // validation for constraint: boolean
        if (!is_null($owns) && !is_bool($owns)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($owns, true), gettype($owns)), __LINE__);
        }
        $this->owns = $owns;
        return $this;
    }
}
