<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GeometryArrayPropertyType StructType
 * @subpackage Structs
 */
class GeometryArrayPropertyType extends AbstractStructBase
{
    /**
     * The AbstractGeometry
     * @var \StructType\AbstractGeometryType
     */
    public $AbstractGeometry;
    /**
     * The owns
     * @var bool
     */
    public $owns;
    /**
     * Constructor method for GeometryArrayPropertyType
     * @uses GeometryArrayPropertyType::setAbstractGeometry()
     * @uses GeometryArrayPropertyType::setOwns()
     * @param \StructType\AbstractGeometryType $abstractGeometry
     * @param bool $owns
     */
    public function __construct(\StructType\AbstractGeometryType $abstractGeometry = null, $owns = null)
    {
        $this
            ->setAbstractGeometry($abstractGeometry)
            ->setOwns($owns);
    }
    /**
     * Get AbstractGeometry value
     * @return \StructType\AbstractGeometryType|null
     */
    public function getAbstractGeometry()
    {
        return $this->AbstractGeometry;
    }
    /**
     * Set AbstractGeometry value
     * @param \StructType\AbstractGeometryType $abstractGeometry
     * @return \StructType\GeometryArrayPropertyType
     */
    public function setAbstractGeometry(\StructType\AbstractGeometryType $abstractGeometry = null)
    {
        $this->AbstractGeometry = $abstractGeometry;
        return $this;
    }
    /**
     * Get owns value
     * @return bool|null
     */
    public function getOwns()
    {
        return $this->owns;
    }
    /**
     * Set owns value
     * @param bool $owns
     * @return \StructType\GeometryArrayPropertyType
     */
    public function setOwns($owns = null)
    {
        // validation for constraint: boolean
        if (!is_null($owns) && !is_bool($owns)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($owns, true), gettype($owns)), __LINE__);
        }
        $this->owns = $owns;
        return $this;
    }
}
