<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GeodeticCRSType StructType
 * @subpackage Structs
 */
class GeodeticCRSType extends AbstractStructBase
{
    /**
     * The ellipsoidalCS
     * @var \StructType\EllipsoidalCSPropertyType
     */
    public $ellipsoidalCS;
    /**
     * The cartesianCS
     * @var \StructType\CartesianCSPropertyType
     */
    public $cartesianCS;
    /**
     * The sphericalCS
     * @var \StructType\SphericalCSPropertyType
     */
    public $sphericalCS;
    /**
     * The geodeticDatum
     * @var \StructType\GeodeticDatumPropertyType
     */
    public $geodeticDatum;
    /**
     * Constructor method for GeodeticCRSType
     * @uses GeodeticCRSType::setEllipsoidalCS()
     * @uses GeodeticCRSType::setCartesianCS()
     * @uses GeodeticCRSType::setSphericalCS()
     * @uses GeodeticCRSType::setGeodeticDatum()
     * @param \StructType\EllipsoidalCSPropertyType $ellipsoidalCS
     * @param \StructType\CartesianCSPropertyType $cartesianCS
     * @param \StructType\SphericalCSPropertyType $sphericalCS
     * @param \StructType\GeodeticDatumPropertyType $geodeticDatum
     */
    public function __construct(\StructType\EllipsoidalCSPropertyType $ellipsoidalCS = null, \StructType\CartesianCSPropertyType $cartesianCS = null, \StructType\SphericalCSPropertyType $sphericalCS = null, \StructType\GeodeticDatumPropertyType $geodeticDatum = null)
    {
        $this
            ->setEllipsoidalCS($ellipsoidalCS)
            ->setCartesianCS($cartesianCS)
            ->setSphericalCS($sphericalCS)
            ->setGeodeticDatum($geodeticDatum);
    }
    /**
     * Get ellipsoidalCS value
     * @return \StructType\EllipsoidalCSPropertyType|null
     */
    public function getEllipsoidalCS()
    {
        return $this->ellipsoidalCS;
    }
    /**
     * Set ellipsoidalCS value
     * @param \StructType\EllipsoidalCSPropertyType $ellipsoidalCS
     * @return \StructType\GeodeticCRSType
     */
    public function setEllipsoidalCS(\StructType\EllipsoidalCSPropertyType $ellipsoidalCS = null)
    {
        $this->ellipsoidalCS = $ellipsoidalCS;
        return $this;
    }
    /**
     * Get cartesianCS value
     * @return \StructType\CartesianCSPropertyType|null
     */
    public function getCartesianCS()
    {
        return $this->cartesianCS;
    }
    /**
     * Set cartesianCS value
     * @param \StructType\CartesianCSPropertyType $cartesianCS
     * @return \StructType\GeodeticCRSType
     */
    public function setCartesianCS(\StructType\CartesianCSPropertyType $cartesianCS = null)
    {
        $this->cartesianCS = $cartesianCS;
        return $this;
    }
    /**
     * Get sphericalCS value
     * @return \StructType\SphericalCSPropertyType|null
     */
    public function getSphericalCS()
    {
        return $this->sphericalCS;
    }
    /**
     * Set sphericalCS value
     * @param \StructType\SphericalCSPropertyType $sphericalCS
     * @return \StructType\GeodeticCRSType
     */
    public function setSphericalCS(\StructType\SphericalCSPropertyType $sphericalCS = null)
    {
        $this->sphericalCS = $sphericalCS;
        return $this;
    }
    /**
     * Get geodeticDatum value
     * @return \StructType\GeodeticDatumPropertyType|null
     */
    public function getGeodeticDatum()
    {
        return $this->geodeticDatum;
    }
    /**
     * Set geodeticDatum value
     * @param \StructType\GeodeticDatumPropertyType $geodeticDatum
     * @return \StructType\GeodeticCRSType
     */
    public function setGeodeticDatum(\StructType\GeodeticDatumPropertyType $geodeticDatum = null)
    {
        $this->geodeticDatum = $geodeticDatum;
        return $this;
    }
}
